"use client";
import ProductCard from "@/app/ui/shared/ProductCard";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";
import Autoplay from "embla-carousel-autoplay";
import SectionHeader from "../SectionHeader";
export default function MainSectionUiRedesignTwo({
  displayTitle,
  title,
  marker,
  productsData,
  styles,
  iconColor,
  sectionId,
}) {
  const productsDataToDisplay =
    sectionId == process.env.NEXT_PUBLIC_PANEX_PHARMA_NEW_PRODUCTS_SECTION_ID
      ? productsData.filter((product) => !!product?.price)
      : productsData;

  return (
    <>
      {displayTitle == "1" ? (
        <SectionHeader
          title={title}
          marker={marker}
          withLink={false}
          link={"/products/310"}
        />
      ) : null}
      <Carousel
        className="group/carousel"
        dir="ltr"
        opts={{
          loop: true,
          align: "start",
        }}
        plugins={[
          Autoplay({
            delay: 3000,
          }),
        ]}
      >
        <CarouselContent>
          {productsDataToDisplay?.map((item) => (
            <CarouselItem key={item.id} className={`mt-2 ${styles}`}>
              <ProductCard product={item} sectionId={sectionId} />
            </CarouselItem>
          ))}
        </CarouselContent>
        <CarouselPrevious
          className={`${iconColor} bg-main text-white !size-12 hover:bg-secondary hover:opacity-100 translate-x-12 opacity-0 transition-all transform  duration-500 ease-in-out group-hover/carousel:translate-x-14 group-hover/carousel:opacity-60 border-none`}
        />
        <CarouselNext
          className={`${iconColor} bg-main text-white !size-12 hover:bg-secondary hover:opacity-100 -translate-x-12 opacity-0 transition-all transform  duration-500 ease-in-out group-hover/carousel:-translate-x-14 group-hover/carousel:opacity-60 border-none`}
        />
      </Carousel>
    </>
  );
}
