"use client";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import { useTranslations } from "next-intl";

const SideBannerRedesignTwo = ({ data, displayTitle, published }) => {
  const t = useTranslations('shared')

  return (
    published == "1" ?
      <div className=" bg-white ">
        <div className=" w-full" style={{
          backgroundImage: `url(${data.image})`,
          backgroundSize: "cover",
          backgroundPosition: "center",
        }}>
        </div>
        <div className="text-center lg:p-6 p-4 space-y-4 ">
          <p className="font-bold text-2xl">
            {displayTitle == "1" ?
              data.title : data.banner_title || "title"
            }
          </p>
          <Link
            href={data.link}
            className="border-b border-main mx-auto flex items-center gap-2 font-bold w-fit p-2 hover:bg-black hover:text-white transition-all duration-300"
          >
            <FaArrowRight size={14} />
            {t('shaping-now')}
          </Link>
        </div>
      </div> : null
   
  );
};

export default SideBannerRedesignTwo;
