import fetchData from "@/api/fetch-data";

import SectionHeader from "../../../SectionHeader";
import SideSectionUiRedesignTwo from "./SideSectionUiRedesignTwo";

export default async function SideSectionRedesignTwo({ sectionType, title, displayTitle, published }) {
  let productsData;

  // handled title and marker
  const words = title.trim().split(" ");
  const lastWord = words.pop();
  const restOfTitle = words.join(" ");
  // handled banner or products layout
  if (published == "1") {
    const response = await fetchData({ endPoint: `/sections/${sectionType}` });
    if (response.status == "success") {
      productsData = response.data[0].products;
    }
  }
  return (
    published == "1" ?
      <div>
        {displayTitle == "1" ?
          <SectionHeader title={restOfTitle} marker={lastWord} withLink={false} />
          : null
        }
        <SideSectionUiRedesignTwo productsData={productsData} />
      </div> : null
  );
}
