"use client"
import ProductCard from "@/app/ui/shared/ProductCard";
import { Carousel, CarouselContent, CarouselItem, CarouselNext, CarouselPrevious } from "@/components/ui/carousel";
import Autoplay from "embla-carousel-autoplay";
export default function SideSectionUiRedesignTwo({ productsData }) {


    return (
        <>
            <Carousel
                className="group/carousel"
                dir="ltr"
                opts={{
                    loop: true,
                    align: 'start',
                }}
                plugins={[
                    Autoplay({
                        delay: 3000,
                    }),
                ]}
            >
                <CarouselContent>
                    {productsData.map((item) => (
                        <CarouselItem key={item.id} className="mt-2 md:basis-1/2 lg:basis-1/3 xl:basis-1/6" >
                            <ProductCard product={item} />
                        </CarouselItem>
                    ))}
                </CarouselContent>
                <CarouselPrevious className='bg-main !size-12 hover:bg-secondary hover:opacity-100 translate-x-12 opacity-0 transition-all transform text-white duration-500 ease-in-out group-hover/carousel:translate-x-14 group-hover/carousel:opacity-60 border-none' />
                <CarouselNext className='bg-main !size-12 hover:bg-secondary hover:opacity-100 -translate-x-12 opacity-0 transition-all transform text-white duration-500 ease-in-out group-hover/carousel:-translate-x-14 group-hover/carousel:opacity-60 border-none' />
            </Carousel>
        </>
    )
}
