"use client";
import fetchData from "@/api/fetch-data";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";
import useWishlistStore from "@/stores/wishlist";
import clsx from "clsx";
import Autoplay from "embla-carousel-autoplay";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { useEffect, useState } from "react";
import FallbackImage from "../FallbackImage";

const backgroundSliderColors = ["#111113", "#C29C94", "#2A409A"];

const MainSliderRedesignThree = ({ sliderArray }) => {
  const locale = useLocale();
  const t = useTranslations("shared");
  const [api, setApi] = useState();
  const [currentSlide, setCurrentSlide] = useState(0);
  const [totalSlides, setTotalSlides] = useState();
  const { setWishlistFromAPI } = useWishlistStore();

  useEffect(() => {
    async function fetchWishlist() {
      const response = await fetchData({
        endPoint: "/user/favourites",
      });
      setWishlistFromAPI(response.data); // Update Zustand store with API data
    }
    fetchWishlist();
    if (!api) {
      return;
    }
    setTotalSlides(api.slideNodes().length);
    api.on("select", () => {
      setCurrentSlide(api.selectedScrollSnap());
    });
  }, [api, setWishlistFromAPI]);

  return sliderArray?.length > 0 ? (
    <div className=" rounded-lg mb-6 group">
      <Carousel
        className="w-full relative rounded-lg overflow-hidden "
        setApi={setApi}
        dir="ltr"
        opts={{
          loop: true,
        }}
        plugins={[
          Autoplay({
            delay: 7000,
          }),
        ]}
      >
        <CarouselContent>
          {sliderArray.map((item, index) => (
            <CarouselItem key={index} className="basis-full">
              <div dir={locale == "ar" ? "rtl" : "ltr"}>
                <div
                  style={{
                    backgroundColor:
                      backgroundSliderColors[
                        index % backgroundSliderColors.length
                      ],
                  }}
                  className=" py-6 lg:px-24 px-6 rounded-2xl  "
                >
                  <div className="flex items-center md:flex-row flex-col lg:gap-6 gap-4 ">
                    {/* image */}
                    <div className="md:w-80 lg:h-96 md:h-80 relative">
                      <FallbackImage
                        src={item?.image}
                        alt={item?.data[0]?.name}
                        fill
                        className="object-contain"
                      />
                    </div>
                    {/* content */}
                    <div className="text-white  md:text-start text-center space-y-6">
                      <h2 className="m-0 lg:text-2xl text-lg">
                        {item?.data[0]?.name}{" "}
                      </h2>
                      <h2 className="lg:text-5xl text-2xl font-bold m-0">
                        {item?.data[0]?.description}
                      </h2>
                      <Link
                        href={item?.url}
                        className="bg-secondary text-main p-3 px-6 rounded-md font-semibold hover:bg-white  duration-300 transition-all block w-fit text-base mx-auto md:mx-0"
                      >
                        {t("show-more")}
                      </Link>
                    </div>
                  </div>
                </div>
              </div>
            </CarouselItem>
          ))}
        </CarouselContent>
        <div
          className={`flex justify-center mt-4 gap-2 overflow-x-auto pb-2 lg:absolute bottom-10 ${
            locale == "ar" ? "left-1/2" : "right-1/2"
          }`}
        >
          {Array.from({ length: totalSlides }).map((_, index) => (
            <button
              key={index}
              className={clsx(
                `size-4 rounded-full  transition-all duration-300 flex-shrink-0 hover:bg-secondary `,
                {
                  " bg-secondary ": index == currentSlide,
                  "bg-white": index != currentSlide,
                }
              )}
              onClick={() => api?.scrollTo(index)}
            />
          ))}
        </div>
        <CarouselPrevious className="bg-secondary  text-main !size-12 hover:bg-secondary  translate-x-16  transition-all transform  duration-500 ease-in-out   border-none hover:text-main hidden lg:flex opacity-0 group-hover:opacity-100" />
        <CarouselNext className="bg-secondary text-main !size-12 hover:bg-secondary -translate-x-16  transition-all transform  duration-500 ease-in-out   border-none hover:text-main hidden lg:flex opacity-0 group-hover:opacity-100" />
      </Carousel>
    </div>
  ) : (
    <></>
  );
};

export default MainSliderRedesignThree;
