import Image from "next/image";

export default function Maintance({ maintenanceMessage, maintenanceTitle }) {
  return (
    <section className="absolute inset-0 z-[2222222222222222222] overflow-hidden flex items-center justify-center flex-col">
      <div className="w-full flex-col justify-start items-center gap-2.5 flex">
        <h2 className="text-center text-gray-800 text-3xl font-bold font-manrope leading-normal">
          {maintenanceTitle}
        </h2>
        <p className="text-center text-gray-500 text-base font-normal leading-relaxed">
          {maintenanceMessage}
        </p>
      </div>
      <Image
        unoptimized
        src="https://pagedone.io/asset/uploads/1718004199.png"
        alt="under maintenance image"
        width={720}
        height={520}
        className="object-cover max-md:hidden"
      />
    </section>
  );
}
