"use client";

import { createVendor } from "@/actions/cookies";
import { Separator } from "@/components/ui/separator";
import { useSettings } from "@/stores/settings";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect } from "react";
import { FaRegHeart } from "react-icons/fa";
import { FiUser } from "react-icons/fi";
import Cart from "../cart/Cart";
import CategoriesMenu from "./CategoriesMenu";
import CurrencySwitcher from "./CurrencySwitcher";
import FallbackImage from "./FallbackImage";
import LangSwitcher from "./LangSwitcher";
import NavbarSheet from "./NavbarSheet";
import SearchBox from "./SearchBox";
import UserDropdown from "./UserDropdown";
import LoginPopover from "./LoginPopover";

export default function NavBarUi({
  profile,
  currenciesResponse,
  categoriesResponse,
  settingsResponse,
}) {
  const t = useTranslations("navbar");
  const pathname = usePathname(); // Get current path

  const isActive = (path) => pathname === path; // Helper to check active path
  const { setSettings } = useSettings();

  useEffect(() => {
    async function setVendorPermission() {
      await createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    }
    setVendorPermission();
  }, [settingsResponse?.site_settings?.is_multi_vendor]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  return (
    <nav className="relative top-0 start-0 end-0">
      {/* app and info */}
      <div className="bg-[#F5F5F5] shadow-sm">
        <div className="container flex items-center lg:justify-between justify-center">
          {/* app download */}
          <div className="lg:flex hidden items-center gap-4 ">
            <Link href="/">
              <FallbackImage
                src="/navbar/google.svg"
                alt="google"
                width={20}
                height={20}
              />
            </Link>
            <Link href="/">
              <FallbackImage
                src="/navbar/apple.svg"
                alt="apple"
                width={20}
                height={20}
              />
            </Link>
          </div>
          <div className=" flex max-md:hidden mx-5 lg:hidden">
            <Link href="/">
              <FallbackImage
                src={
                  settingsResponse?.images?.header ||
                  siteSettingFallback?.images?.header
                }
                alt="logo"
                width={50}
                height={70}
              />
            </Link>
          </div>
          {/* location and language switcher */}
          <div className="text-secondary flex items-center justify-between max-md:hidden gap-2 md:gap-4">
            {/* currency */}
            <CurrencySwitcher response={currenciesResponse} />
            {/* langSwitcher */}
            <LangSwitcher
              languages={
                settingsResponse?.languages || siteSettingFallback?.languages
              }
            />
          </div>
        </div>
      </div>
      {/* nav and logo */}
      <div className="bg-body py-2 md:py-4">
        <div className="container flex justify-between items-center gap-4">
          {/* logo */}
          <div className="max-lg:hidden">
            <Link href="/">
              <FallbackImage
                src={
                  settingsResponse?.images?.header ||
                  siteSettingFallback?.images?.header
                }
                alt="logo"
                width={70}
                height={70}
              />
            </Link>
          </div>
          {/* location and language switcher */}
          <div className="text-secondary flex md:hidden items-center justify-between max-md:w-full gap-2 md:gap-4">
            <div className=" flex ">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={50}
                  height={70}
                />
              </Link>
            </div>
            <div className="flex items-center">
              {/* currency */}
              <CurrencySwitcher response={currenciesResponse} />
              {/* langSwitcher */}
              <LangSwitcher
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
            </div>
          </div>
          {/* sheet */}
          <div className="block lg:hidden">
            <NavbarSheet profile={profile} />
          </div>
          {/* nav */}
          <div className="text-secondary hidden lg:flex items-center gap-3">
            {/* start home */}
            <Link
              href="/"
              className={`text-base ${isActive("/") ? "text-main font-bold" : ""
                }`}
            >
              {t("home")}
            </Link>
            {/* end home */}
            {/* start wishlist */}
            {profile && (
              <>
                <Separator orientation="vertical" className="h-6" />
                <Link
                  href="/wishlist"
                  className={`flex items-center gap-2 text-base ${isActive("/wishlist") ? "text-main font-bold" : ""
                    }`}
                >
                  <FaRegHeart size={20} className="text-main" />
                  {t("wishlist")}
                </Link>
              </>
            )}
            {/* end wishlist */}

            {/* start brands */}
            <Separator orientation="vertical" className="h-6" />
            <Link
              href="/brands"
              className={` text-base ${isActive("/brands") ? "text-main font-bold" : ""
                }`}
            >
              {t("marks")}
            </Link>
            {/* end brands */}

            {/* start offers */}
            <Separator orientation="vertical" className="h-6" />
            <Link
              href="/offers"
              className={`text-base ${isActive("/offers") ? "text-main font-bold" : ""
                }`}
            >
              {t("shows")}
            </Link>
            {/* end offers */}

            {/* start cart */}
            <Separator orientation="vertical" className="h-6" />
            <Cart profile={profile} />
            {/* end cart */}

            {/* start sign in and profile */}
            <Separator orientation="vertical" className="h-6" />
            {!profile ? (
              <LoginPopover />
            ) : (
              <div className="hidden lg:block">
                <UserDropdown user={profile} />
              </div>
            )}
            {/* end sign in and profile */}
          </div>

          {/* searchbox */}
          <div className="grow hidden lg:block">
            <SearchBox />
          </div>
          {/* categories */}
          <div className="hidden lg:block">
            <CategoriesMenu response={categoriesResponse} />
          </div>
        </div>
      </div>
    </nav>
  );
}