import fetchData from "@/api/fetch-data";
import getUserProfile from "@/api/user/getUserProfile";
import {
  dehydrate,
  HydrationBoundary,
  QueryClient,
} from "@tanstack/react-query";
import RedesignThreeNavbar from "./navbars/RedesignThreeNavbar/RedesignThreeNavbar";
import { STALE_TIME } from "@/constants";
import { getLocale } from "next-intl/server";

const Navbar = async ({ settingsResponse }) => {
  const profile = await getUserProfile();
  const queryClient = new QueryClient();
  const l = await getLocale();

  // start to fetch links early
  queryClient.prefetchQuery({
    queryKey: ["/links", l],
    queryFn: () => fetchData({ endPoint: "/links" }),
    staleTime: STALE_TIME.LONG,
  });

  return (
    <HydrationBoundary state={dehydrate(queryClient)}>
      <RedesignThreeNavbar
        profile={profile}
        settingsResponse={settingsResponse}
      />
    </HydrationBoundary>
  );
};

export default Navbar;
