"use client";
import {
  Sheet,
  SheetClose,
  SheetContent,
  SheetDescription,
  SheetHeader,
  SheetTrigger,
} from "@/components/ui/sheet";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { FaBars, FaHome, FaRegHeart } from "react-icons/fa";
import Cart from "../cart/Cart";
import SearchBox from "./SearchBox";
import UserDropdown from "./UserDropdown";
import LoginPopoverRedesignThree from "./navbars/RedesignThreeNavbar/LoginPopoverRedesignThree";
import { createLink } from "./navbars/RedesignThreeNavbar/NavLinks";

const links = [
  {
    name: "about-us",
    href: "/about-us",
  },
  {
    name: "panexPharmaProducts",
    href: "/categories",
  },
  {
    name: "sellPigeonsFixedPrice",
    href: "/brands",
  },
  {
    name: "productsWithNoPrice",
    href: `/products/filter/${process.env.NEXT_PUBLIC_NO_PRICE_CATEGORY_ID}`,
  },
  {
    name: "offers",
    href: "/offers",
  },
  {
    name: "articles",
    href: "/articles",
  },
  {
    name: "agents",
    href: "/agents",
  },
  {
    name: "contact",
    href: "/contact",
  },
];
const NavbarSheet = ({ profile, data }) => {
 
  const locale = useLocale();
  const t = useTranslations("navbar");

  const showDynamicLinks =
    data?.data && Array.isArray(data.data) && data.data.length > 0;

  return (
    <nav className="fixed bottom-0 left-0 z-50 w-full h-16 bg-gray-100 border-t border-gray-200 ">
      <div className="grid h-full  font-bold w-full grid-cols-5 items-center justify-evenly">
        {/*start Home */}
        <Link href="/" className="flex items-center justify-center text-main">
          <FaHome size={30} />
        </Link>
        {/* end Home */}
        {/*start Home */}
        <Link href="/" className="flex items-center justify-center text-main">
          <FaRegHeart size={30} />
        </Link>
        {/* end Home */}
        {/* start user */}
        <div className="">
          {!profile ? (
            <LoginPopoverRedesignThree sheet={true} />
          ) : (
            <UserDropdown user={profile} />
          )}
        </div>
        {/* end user */}

        {/*start Cart */}
        <div className="flex items-center justify-center text-main ">
          <Cart profile={profile} sheet={true} />
        </div>
        {/*end Cart */}

        {/* start more */}
        <Sheet>
          <SheetTrigger className="rounded-none text-main flex items-center flex-col justify-center">
            <FaBars size={30} />
          </SheetTrigger>
          <SheetContent
            side={locale === "en" ? "left" : "right"}
            className="z-[101]"
          >
            <SheetHeader>
              <SheetDescription className="gap-y-6 pt-6 flex flex-col">
                <SearchBox />
                {/* home */}
                <SheetClose>
                  <Link
                    href={"/"}
                    className="flex items-center gap-2 text-base"
                  >
                    {t("home")}
                  </Link>
                </SheetClose>
                {showDynamicLinks
                  ? data?.data?.map((link) => (
                      <SheetClose asChild key={link.name}>
                        <Link
                          target={!!link.open_blank ? "_blank" : "_self"}
                          key={link?.type + link?.id}
                          href={createLink(link)}
                          className="flex items-center gap-2 text-base"
                        >
                          {link.title}
                        </Link>
                      </SheetClose>
                    ))
                  : links?.map((link) => (
                      <SheetClose asChild key={link.name}>
                        <Link
                          href={link.href}
                          className="flex items-center gap-2 text-base"
                        >
                          <FaHome size={20} className="text-main" />
                          {t(link.name)}
                        </Link>
                      </SheetClose>
                    ))}
              </SheetDescription>
            </SheetHeader>
          </SheetContent>
        </Sheet>
      </div>
    </nav>
  );
};

export default NavbarSheet;
