import { IoClose } from 'react-icons/io5';

export default function PopUpForm({ title, form, showModal, setShowModal }) {
    return (
        <div className={`fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 ${!showModal ? "hidden" : ""}`}>
            <div className="bg-white max-md:w-[90%] relative rounded-lg shadow-lg max-w-md w-full">
                <button type="button" className="text-black absolute top-5 end-5 text-xl hover:text-red-400 rounded" onClick={() => setShowModal(false)}>
                    <IoClose />
                </button>
                <h2 className="text-lg px-6 pt-6 font-extrabold mb-4 w-full pb-2 border-b-[1px]">{title}</h2>
                {form}
            </div>
        </div>
    );
}
