import { Loader2 } from "lucide-react";
import Link from "next/link";
import { FaSpinner } from "react-icons/fa6";
import { IoMdHeart } from "react-icons/io";
import { IoStar } from "react-icons/io5";
import { TbShoppingBagPlus } from "react-icons/tb";
import FallbackImage from "./FallbackImage";
import { useTranslations } from "next-intl";

export default function ProductCardUI(
    { handleToggleItem,
        handleAddToCart,
        productTitle,
        productPhoto,
        isWishlisted,
        isFavLoading,
        product,
        isPending,
        currencyShortname,
        rate }) {
    const t = useTranslations("cart");
    return (
        <>
            {product ?
                <div className="bldock bg-white flex flex-col justify-between h-full p-2 md:p-4 lg:p-8 space-y-4 hover:shadow-lg hover:scale-[1.02] transition-all duration-300">
                    {/* Wishlist and rating */}
                    <div className="flex items-center  justify-between">
                        <div
                            className={`flex items-center gap-2 ${isWishlisted ? "text-red-500" : "text-red-300"
                                } hover:text-red-500`}
                        >
                            {isFavLoading ? (
                                <FaSpinner className="animate-spin" />
                            ) : (
                                <IoMdHeart
                                    size={22}
                                    onClick={handleToggleItem}
                                    className="cursor-pointer"
                                />
                            )}
                            {/* Discount */}
                            {product.discount && (
                                <span className="bg-green-500 text-xs text-white rounded-md p-1">
                                    {Math.floor(product.discount)}%
                                </span>
                            )}
                        </div>
                        {product.rate && (
                            <div className="flex items-center gap-1">
                                <IoStar size={20} className="text-yellow-400" />
                                <p className="font-semibold pt-1">
                                    {parseFloat(product.rate).toFixed(1)}
                                </p>
                            </div>
                        )}
                    </div>

                    {/* Product image and details */}
                    <Link href={`/products/${product.id}`} className=" block space-y-4">
                        <div className=" h-24 md:h-36 relative">
                            <FallbackImage
                                src={productPhoto}
                                alt={product.title || "product"}
                                fill
                                className="object-contain"
                            />
                        </div>
                        <div className="text-center space-y-2 3xl:text-xl text-lg">
                            <h3 className="font-semibold line-clamp-1">{productTitle}</h3>
                            <p className="font-bold space-x-2">
                                {parseFloat(
                                    (product.price - product.price * (product.discount / 100)) * rate
                                ).toFixed(2)}
                                &nbsp;<span className="text-sm text-main">{currencyShortname}</span>
                            </p>
                        </div>
                    </Link>

                    {/* Add to cart button */}
                    <button
                        disabled={isPending}
                        onClick={handleAddToCart}
                        className="btn btn-btnColor self-end h-12 max-md:h-9 max-md:text-xs flex items-center justify-center w-full  mx-auto"
                    >
                        {isPending ? (
                            <Loader2 size={20} className="text-yellow-400 animate-spin" />
                        ) : (
                            <>
                                <TbShoppingBagPlus
                                    size={20}
                                    className="text-yellow-400 max-md:hidden"
                                />
                                &nbsp;{t("add-to-cart")}
                            </>
                        )}
                    </button>
                </div>
                : ""}
        </>

    )
}
