import { Star } from 'lucide-react';

export default function Rate({ size = 18, rating = 0 }) {
   const stars = Number(rating);
   return (
      <div className="flex gap-1 items-center">
         {Array.from({ length: 5 }).map((_, index) => (
            <Star
               fill={index < stars ? "#FFB800" : "white"}
               color='#FFB800'
               key={index}
               size={size}
            />
         ))}
      </div>
   );
}
