'use client'
import { useState, useEffect } from 'react';
import { MdOutlineKeyboardDoubleArrowUp } from "react-icons/md";

const ScrollToTopButton = () => {
  const [isVisible, setIsVisible] = useState(false);
  // Handle scroll to show/hide button
  useEffect(() => {
    const toggleVisibility = () => {
      if (window.scrollY > 300) {
        setIsVisible(true);
      } else {
        setIsVisible(false);
      }
    };

    window.addEventListener('scroll', toggleVisibility);
    return () => window.removeEventListener('scroll', toggleVisibility);
  }, []);


  const scrollToTop = () => {
    window.scrollTo({
      top: 0,
      behavior: 'smooth',
    });
  };

  return (
    <button
      onClick={scrollToTop}
      className={`fixed bottom-4 right-4 w-10 h-10 rounded-full bg-mainDark text-white shadow-lg hover:bg-secondary transition-all
        border-2 border-white  duration-300  flex items-center justify-center ${isVisible ? 'opacity-100' : 'opacity-0 pointer-events-none'
        }`}
      aria-label="Scroll to top"
    >
      <MdOutlineKeyboardDoubleArrowUp className='text-2xl ' />
    </button>
  );
};

export default ScrollToTopButton;
