import { useLocale } from "next-intl";
import Link from "next/link";
import { LuChevronRight, LuChevronLeft } from "react-icons/lu";

const SectionHeader = ({
  title = "",
  marker = "",
  withLink = true,
  link = "#",
}) => {
  const locale = useLocale();

  return (
    //  DEFAULT THEME
    // <div>
    //   <div className=" border-b-2 flex items-center justify-between">
    //     <h2 className="text-secondary md:text-xl py-3">
    //       {title}{" "}
    //       <span className="relative text-main font-semibold before:w-full before:h-[2px] before:bg-main before:absolute before:-bottom-3 before:rounded-full">
    //         {marker}
    //       </span>
    //     </h2>
    //     {withLink ? (
    //       locale == "ar" ?
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main"
    //         >
    //           عرض الكل
    //           <LuChevronLeft size={22} className="text-maidn" />
    //         </Link> :
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main"
    //         >
    //           View All
    //           <LuChevronRight size={22} className="text-main" />
    //         </Link>
    //     ) : null}
    //   </div>
    // </div>
    // REDESIGN THEME
    // <div className="flex flex-col  gap-2">
    //   <div className="flex items-center justify-between    gap-2">
    //     <h2 className="text-black font-semibold text-xl 2xl:text-3xl p-0">
    //       {title} {marker}
    //     </h2>
    //     {withLink ? (
    //       locale == "ar" ? (
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main p-0 "
    //         >
    //           عرض الكل
    //           <LuChevronLeft size={22} className="" />
    //         </Link>
    //       ) : (
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main p-0"
    //         >
    //           View All
    //           <LuChevronRight size={22} className="text-main" />
    //         </Link>
    //       )
    //     ) : null}
    //   </div>
    //   <div className="h-[1px] bg-gray-300 w-[100%] lg:mt-3  grow"></div>
    // </div>

    // REDESIGN THREE
    <div className="flex flex-col  gap-2 pb-4 pt-6 ">
      <div className="flex items-center justify-between    gap-2">
        <h2 className="text-black font-semibold text-xl 2xl:text-3xl p-0">
          {title} {marker}
        </h2>
        {withLink ? (
          locale == "ar" ? (
            <Link
              href={link}
              className=" flex items-center gap-1 text-main hover:text-secondary p-0 "
            >
              عرض الكل
              <LuChevronLeft size={22} className="" />
            </Link>
          ) : (
            <Link
              href={link}
              className="flex items-center gap-1 text-main hover:text-secondary p-0"
            >
              View All
              <LuChevronRight size={22} className="text-main" />
            </Link>
          )
        ) : null}
      </div>
    </div>

    // LIGHT BLUE THEME
    // <div className="my-2">
    //   <div className="  flex items-center justify-between gap-2">
    //     <h2 className="text-secondary md:text-xl p-0">
    //       {title}{" "}
    //       <span className="relative text-main font-semibold p-0">
    //         {marker}
    //       </span>
    //     </h2>
    //     <div className="h-[1px] bg-secondary bg-opacity-50 grow"></div>
    //     {withLink ? (
    //       locale == "ar" ?
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main p-0"
    //         >
    //           عرض الكل
    //           <LuChevronLeft size={22} className="text-main" />
    //         </Link> :
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main p-0"
    //         >
    //           View All
    //           <LuChevronRight size={22} className="text-main" />
    //         </Link>
    //     ) : null}
    //   </div>
    // </div>
  );
};

export default SectionHeader;
