import { useLocale } from "next-intl";
import Link from "next/link";
import { LuChevronLeft } from "react-icons/lu";

const SectionHeaderRedesign = ({
  title = "",
  marker = "",
  withLink = true,
  link = "#",
}) => {
  const locale = useLocale();

  return (
    <div className="my-2">
      <div className="  flex items-center justify-between gap-2">
        <h2 className="text-secondary md:text-xl p-0">
          {title}{" "}
          <span className="relative text-main font-semibold p-0">{marker}</span>
        </h2>
        <div className="h-[1px] bg-secondary bg-opacity-50 grow"></div>
        {withLink && (
          <Link
            href={link}
            className="flex items-center gap-1 text-secondary hover:text-main p-0"
          >
            {locale == "ar" ? "عرض الكل" : "View All"}
            <LuChevronLeft size={22} className="text-main" />
          </Link>
        )}
      </div>
    </div>
  );
};

export default SectionHeaderRedesign;
