"use client"
import { useCurrency } from "@/stores/currency-state";
import Link from "next/link";
import FallbackImage from "./FallbackImage";

export default function SideProductCard({ product }) {
  const { currencyShortname, rate } = useCurrency();

  return (
    <Link href={`/products/${product.id}`} className="col-span-12 " >
      <div className="flex items-center gap-2">
        <FallbackImage
          src={product.cover_photo}
          alt={product.title}
          width={75}
          height={75}
        />
        <div className="space-y-4">
          <h3 className=" font-semibold line-clamp-1">{product.title}</h3>
          <p className=" font-bold space-x-2">
            {currencyShortname} {parseFloat((product.price - (product.price * (product.discount / 100))) * rate).toFixed(2)}{" "}
            {product.discount ?
              <del className="text-sm text-gray-400">
                {parseFloat(product.price * rate).toFixed(2)}
              </del> : null
            }
          </p>
        </div>
      </div>
      
    </Link >
  );
}