"use client";

import { Dialog, DialogClose, DialogContent } from "@/components/ui/dialog";
import { Separator } from "@/components/ui/separator";
import { X } from "lucide-react";
import Image from "next/image";
import { useState } from "react";

export default function GenealogiesList({ lineage }) {
  const content = lineage?.text || [];
  const photos = lineage?.files || [];
  const [selectedImage, setSelectedImage] = useState("#");
  const [dialogOpen, setDialogOpen] = useState(false);

  function displayProductPhoto(url) {
    setSelectedImage(url);
    setDialogOpen(true);
  }

  return (
    <section className="space-y-6 bg-white p-4">
      {content.map((item, index) => {
        return (
          <div key={index} className="space-y-2">
            <h2 className="text-2xl">{item.title}</h2>
            <div
              className="leading-7"
              dangerouslySetInnerHTML={{ __html: item.description || "" }}
            />
          </div>
        );
      })}

      <Separator className="my-4" />

      <div className="flex items-center gap-4 flex-wrap">
        {photos.map((url, index) => {
          return (
            <div
              key={index}
              onClick={() => displayProductPhoto(url)}
              role="button"
              className="p-4 rounded shadow cursor-pointer"
            >
              <Image
                unoptimized
                src={url}
                alt={url}
                width={500}
                height={500}
                className="size-28 object-cover"
              />
            </div>
          );
        })}
      </div>
      <Dialog open={dialogOpen} onOpenChange={setDialogOpen}>
        {" "}
        {/* image dialog */}
        <DialogContent>
          <DialogClose>
            <X />
          </DialogClose>
          <Image
            unoptimized
            src={selectedImage}
            alt="image popover"
            width={1000}
            height={1000}
            className="rounded object-contain"
          />
        </DialogContent>
      </Dialog>
    </section>
  );
}
