import { Button } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import { Loader2 } from "lucide-react";
import { MdOutlineArrowRightAlt } from "react-icons/md";

export default function SubmitButton({
  text = "",
  isIcon = true,
  loading = false,
  Icon = MdOutlineArrowRightAlt,
  className = "",
}) {
  return (
    <Button
      type="submit"
      disabled={loading}
      className={cn("flex gap-4 w-full items-center justify-center", className)}
    >
      {loading ? (
        <>
          {text}
          <Loader2 size={24} className="text-white animate-spin" />
        </>
      ) : (
        <>
          {text}
          {isIcon == true ? (
            <Icon size={24} className="text-white group-hover:scale-125" />
          ) : (
            ""
          )}
        </>
      )}
    </Button>
  );
}
