"use client";
import logout from "@/api/user/logout";
import { Avatar, AvatarImage } from "@/components/ui/avatar";
import { Button } from "@/components/ui/button";
import {
  Dialog,
  DialogClose,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
} from "@/components/ui/dialog";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Separator } from "@/components/ui/separator";
import { toastError, toastSuccess } from "@/services/custom-toast";
import { AvatarFallback } from "@radix-ui/react-avatar";
import { Loader2 } from "lucide-react";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { useState, useTransition } from "react";
import { BsTicketPerforated } from "react-icons/bs";
import { CiBellOn } from "react-icons/ci";
import { HiOutlineChatBubbleBottomCenterText } from "react-icons/hi2";
import { RiUserLine } from "react-icons/ri";
import { TbLogout2 } from "react-icons/tb";
import { TiCreditCard } from "react-icons/ti";

export default function UserDropdown({ user }) {
  const [isPending, startTransition] = useTransition();
  const [showModal, setShowModal] = useState(false);
  const [showDropdown, setShowDropdown] = useState(false);
  const t = useTranslations("user");
  const s = useTranslations("shared");

  const userItems = [
    { href: "/user", icon: <RiUserLine />, title: "myprofile" },
    {
      href: "/user/my-orders",
      icon: <HiOutlineChatBubbleBottomCenterText />,
      title: "myorders",
    },
    { href: "/user/my-credit", icon: <TiCreditCard />, title: "mycredit" },
    {
      href: "/user/my-tickets",
      icon: <BsTicketPerforated />,
      title: "tickets",
    },
    { href: "/user/natofications", icon: <CiBellOn />, title: "natofications" },
  ];

  return (
    <>
      <DropdownMenu open={showDropdown} onOpenChange={setShowDropdown}>
        <DropdownMenuTrigger className="flex cursor-pointer max-md:m-auto max-md:flex-col items-center max-md:justify-center md:gap-2">
          <Avatar className="rounded-full border-2 border-main flex items-center justify-center font-bold size-9">
            <AvatarImage src={user?.image} alt={user?.name} />
            <AvatarFallback className=" text-main">
              {user?.name?.slice(0, 2)?.toUpperCase()}
            </AvatarFallback>
          </Avatar>
          <h2 className="text-sm font-semibold max-lg:hidden ">
            {user?.name && `${user?.name} `}
          </h2>
        </DropdownMenuTrigger>
        <DropdownMenuContent className="min-w-48 w-full z-[101] rounded-md ">
          <div className="flex justify-start items-center gap-2">
            <Avatar className="rounded-full border-2 border-main flex items-center justify-center font-bold size-9">
              <AvatarImage src={user?.image} alt={user?.name} />
              <AvatarFallback className=" text-main">
                {user?.name?.slice(0, 2)?.toUpperCase()}
              </AvatarFallback>
            </Avatar>
            {user?.name && (
              <div className="py-2">
                <h2 className="text-[#666666] text-start text-[15px]">
                  {`${user?.name} ${user?.lastname}` || t("user")}
                </h2>
                <h2
                  className="text-[#999999] text-start text-xs truncate w-32 "
                  dir="ltr"
                >
                  {user?.email || "@"}
                </h2>
              </div>
            )}
          </div>

          <Separator className="my-2" />

          <div className="p-4">
            <ul className="flex flex-col items-start  justify-center">
              {userItems.map((item, i) => (
                <li
                  onClick={() => setShowDropdown(false)}
                  key={i}
                  className="group my-2 flex items-center gap-1 justify-start hover:text-main text-sm cursor-pointer"
                >
                  <Link
                    href={item.href}
                    className={`link-item flex w-full items-center justify-end gap-8 group text-[16px] text-[#484848] duration-150 transition-all`}
                  >
                    <div className="flex items-center justify-center gap-4">
                      {item.icon}
                      <h2 className="group-hover:text-main duration-150 transition-all">
                        {t(item.title)}
                      </h2>
                    </div>
                  </Link>
                </li>
              ))}

              <li
                onClick={() => setShowModal(true)}
                className="group my-2 flex items-center gap-1 justify-start hover:text-main text-sm cursor-pointer"
              >
                <div
                  className={`link-item flex w-full items-center justify-end gap-8 group text-[16px] text-[#484848] duration-150 transition-all`}
                >
                  <div className="flex items-center justify-center gap-4">
                    <TbLogout2 />
                    <h2 className="group-hover:text-main duration-150 transition-all">
                      {s("logout")}
                    </h2>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </DropdownMenuContent>
      </DropdownMenu>

      {/* Logout Dialog */}
      <Dialog open={showModal} onOpenChange={setShowModal}>
        <DialogContent className="w-fit sm:max-w-md overflow-hidden">
          <DialogHeader>
            <DialogTitle>{s("logout")}</DialogTitle>
          </DialogHeader>
          <DialogDescription className="text-sm text-gray-950 lg:text-xl text-center font-bold">
            {s("logout-alert")}
          </DialogDescription>
          <DialogFooter className="flex flex-row justify-center mx-auto items-center gap-6">
            <Button
              className="w-32"
              type="button"
              onClick={() => {
                startTransition(async () => {
                  const { error, message } = await logout();
                  if (error) {
                    toastError(message);
                  } else {
                    toastSuccess(message);
                    localStorage.removeItem("wishlist-storage");
                    setShowModal(false);
                    setShowDropdown(false);
                    location.href = "/";
                  }
                });
              }}
            >
              {isPending ? <Loader2 className="animate-spin" /> : s("yes")}
            </Button>
            <DialogClose asChild>
              <Button className="w-32" type="button" variant="secondary">
                {s("no")}
              </Button>
            </DialogClose>
          </DialogFooter>
        </DialogContent>
      </Dialog>
    </>
  );
}
