"use client";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import {
  HoverCard,
  HoverCardContent,
  HoverCardTrigger,
} from "@/components/ui/hover-card";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { FaBars } from "react-icons/fa";
import {
  IoIosArrowBack,
  IoIosArrowDown,
  IoIosArrowForward,
} from "react-icons/io";

import fetchData from "@/api/fetch-data";
import { Separator } from "@/components/ui/separator";
import { useEffect, useRef, useState } from "react";
export default function CategoriesMenuRedesignThree() {
  const locale = useLocale();
  const [showDropdown, setShowDropdown] = useState(false);
  const [categories, setCategories] = useState([]);
  const t = useTranslations("navbar");

  useEffect(() => {
    async function getCategories() {
      const response = await fetchData({ endPoint: "/categories" });

      if (response?.status == "success") {
        setCategories(response?.data || []);
      }
    }
    getCategories();
  }, [locale]);

  return (
    <div>
      <DropdownMenu
        open={showDropdown}
        onOpenChange={setShowDropdown}
        modal={false}
      >
        <DropdownMenuTrigger className="w-[250px] flex items-center gap-3 text-xl font-bold cursor-pointer bg-secondary text-main p-2 rounded-t-lg">
          <FaBars size={15} />
          {t("panexPharmaProducts")}
          <IoIosArrowDown className="ms-auto" size={14} />
        </DropdownMenuTrigger>

        {categories?.length === 0 ? (
          <DropdownMenuContent className="w-[250px] rounded-none p-4">
            <p className="text-center">{t("no-sections")}</p>
          </DropdownMenuContent>
        ) : (
          <DropdownMenuContent className="w-[250px] rounded-none rounded-b-lg px-0 max-md:max-h-64 max-md:overflow-y-auto">
            {categories?.slice(0, 4)?.map((item, index) => (
              <HoverCard
                key={index}
                openDelay={100}
                closeDelay={100}
                className="relative"
              >
                <HoverCardTrigger onClick={() => setShowDropdown(false)}>
                  <Link
                    href={`/products/filter/${item.id}`}
                    className="group flex p-2 py-6 items-center justify-between gap-1 hover:text-secondary text-sm cursor-pointer"
                    dir={locale === "en" ? "ltr" : "rtl"}
                  >
                    <p className="text-lg line-clamp-1">{item.title}</p>
                    {locale === "en" ? (
                      <IoIosArrowForward className="duration-500 group-hover:rotate-90 hover:text-secondary" />
                    ) : (
                      <IoIosArrowBack className="duration-500 group-hover:-rotate-90 hover:text-secondary" />
                    )}
                  </Link>
                  <Separator className="h-[1px] w-[95%] m-auto bg-gray-200" />
                </HoverCardTrigger>

                <HoverCardContent
                  className={`p-0 lg:absolute ${
                    locale === "ar" ? "lg:end-[125px]" : "lg:start-[125px]"
                  } rounded-none`}
                  style={{
                    top: `-${88 + index * 76}px`,
                  }}
                >
                  {item.sub_categories?.length === 0 ? (
                    <p className="text-center">{t("no-sections")}</p>
                  ) : (
                    <ul dir={locale === "en" ? "ltr" : "rtl"}>
                      {item.sub_categories.map((subItem, subIndex) => (
                        <div key={subIndex}>
                          <li
                            onClick={() => setShowDropdown(false)}
                            className="flex p-2 py-4 items-center"
                          >
                            <Link
                              href={`/products/filter/${subItem.id}`}
                              className="hover:text-secondary text-lg"
                            >
                              {subItem.title}
                            </Link>
                          </li>
                          <Separator className="h-[1px] w-[95%] m-auto bg-gray-200" />
                        </div>
                      ))}
                    </ul>
                  )}
                </HoverCardContent>
              </HoverCard>
            ))}

            <div className="w-fit hover:text-secondary m-auto">
              <Link
                href="/categories"
                onClick={() => setShowDropdown(false)}
                className="flex gap-1 py-6 group items-center justify-center"
              >
                {t("allcategories")}
              </Link>
            </div>
          </DropdownMenuContent>
        )}
      </DropdownMenu>
    </div>
  );
}
