import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { useState } from "react";
import { FiUser } from "react-icons/fi";

export default function LoginPopoverRedesignThree({ sheet = false }) {
  const t = useTranslations("navbar");
  const [isOpen, setIsOpen] = useState(false);

  return (
    <DropdownMenu modal={false} open={isOpen} onOpenChange={setIsOpen}>
      <DropdownMenuTrigger
        className={`flex flex-col mx-auto text-nowrap justify-center items-center cursor-pointer text-xs ${
          sheet ? "text-main" : "gap-2 py-4"
        }`}
      >
        <FiUser size={sheet ? 30 : 20} />
        {!sheet && t("sign-in")}
      </DropdownMenuTrigger>
      <DropdownMenuContent className="w-80 flex flex-col data-[state=closed]:zoom-out-0 data-[state=open]:zoom-in-0">
        <Link
          href="/sign-in"
          className="text-main font-semibold p-3 hover:bg-secondary  hover:scale-105 duration-150 rounded-sm w-full"
          onClick={() => setIsOpen(false)}
        >
          {t("sign-in")}
        </Link>
        <Link
          href="/sign-up"
          className="text-main font-semibold p-3 hover:bg-secondary  hover:scale-105 duration-150 rounded-sm w-full"
          onClick={() => setIsOpen(false)}
        >
          {t("sign-up")}
        </Link>
      </DropdownMenuContent>
    </DropdownMenu>
  );
}
