"use client";

import clsx from "clsx";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { isActive } from "./RedesignThreeNavbar";
import CategoriesMenuRedesignThree from "./CategoriesMenuRedesignThree";

// type is one of four  | link | page | category | product
export const createLink = (link) => {
  // product
  if (link.type === "product") return `/products/${link.id}`;
  // category
  if (link.type === "category") return `/products/filter/${link.id}`;
  //   page
  if (link.type === "page") return `/pages/${link.id}`;
  //   link
  if (link.type === "link") return link.url;
};
export default function NavLinks({ pathname, data, isLoading }) {
  const t = useTranslations("navbar");

  const showDynamicLinks =
    data?.data && Array.isArray(data.data) && data.data.length > 0;

  if (isLoading) {
    return (
      <div
        className={clsx(
          "flex text-nowrap flex-1 text-sm flex-wrap lg:text-base xl:text-lg items-center justify-start gap-6 py-2 text-white font-medium"
        )}
      >
        {/* start home */}
        <Link
          href="/"
          className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
            isActive("/", pathname)
              ? "text-secondary font-extrabold"
              : "text-white font-medium"
          }`}
        >
          {t("home")}
          <span
            className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
              isActive("/", pathname) ? "scale-x-100" : "text-white"
            }`}
          ></span>
        </Link>
        {/* end home */}
        {/* start categories */}
        <CategoriesMenuRedesignThree />
        {/* end auctions */}
      </div>
    );
  }

  if (showDynamicLinks) {
    return (
      <div
        className={clsx(
          "flex text-nowrap flex-1 text-sm flex-wrap lg:text-base xl:text-lg items-center justify-start gap-6 py-2 text-white font-medium"
        )}
      >
        {/* start home */}
        <Link
          href="/"
          className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
            isActive("/", pathname)
              ? "text-secondary font-extrabold"
              : "text-white font-medium"
          }`}
        >
          {t("home")}
          <span
            className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
              isActive("/", pathname) ? "scale-x-100" : "text-white"
            }`}
          ></span>
        </Link>
        {/* end home */}
        {/* start categories */}
        <CategoriesMenuRedesignThree />
        {/* end categories */}

        {data.data.map((link) => (
          <Link
            target={!!link.open_blank ? "_blank" : "_self"}
            key={link?.type + link?.id}
            href={createLink(link)}
            className={` hover:text-secondary relative transition-all duration-300 ease-in-out   ${
              isActive(createLink(link), pathname)
                ? "text-secondary font-extrabold"
                : "text-white font-medium"
            }`}
          >
            {link.title}
            <span
              className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                isActive(createLink(link), pathname)
                  ? "scale-x-100"
                  : "text-white"
              }`}
            ></span>
          </Link>
        ))}
      </div>
    );
  }

  return (
    <div
      className={clsx(
        "flex flex-wrap text-nowrap flex-1 text-sm lg:text-base xl:text-lg items-center justify-start gap-6 py-2"
      )}
    >
      {/* start home */}
      <Link
        href="/"
        className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("home")}
        <span
          className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* end home */}
      {/* start auctions */}
      <Link
        href="/auctions"
        className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/auctions", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("auctions")}
        <span
          className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/auctions", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* end auctions */}
      {/* start about-us */}
      <Link
        href="/about-us"
        className={`hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/about-us", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("about-us")}
        <span
          className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/about-us", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* end about-us */}
      {/* start sellPigeonsFixedPrice */}
      <Link
        href="/brands"
        className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/brands", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("sellPigeonsFixedPrice")}
        <span
          className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/brands", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* end sellPigeonsFixedPrice */}
      {/* start products with no price */}
      {process.env.NEXT_PUBLIC_NO_PRICE_CATEGORY_ID && (
        <Link
          href={`/products/filter/${process.env.NEXT_PUBLIC_NO_PRICE_CATEGORY_ID}`}
          className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
            isActive(
              `/products/filter/${process.env.NEXT_PUBLIC_NO_PRICE_CATEGORY_ID}`,
              pathname
            )
              ? "text-secondary font-extrabold "
              : "text-white font-medium"
          }`}
        >
          {t("productsWithNoPrice")}
          <span
            className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
              isActive(
                `/products/filter/${process.env.NEXT_PUBLIC_NO_PRICE_CATEGORY_ID}`,
                pathname
              )
                ? "scale-x-100"
                : "text-white"
            }`}
          ></span>
        </Link>
      )}
      {/* end products with no price */}
      {/* start offers */}
      <Link
        href="/offers"
        className={` hover:text-secondary relative transition-all duration-300 ease-in-out text-secondary ${
          isActive("/offers", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("offers")}
        <span
          className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/offers", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* end offers */}
      {/* start blogs */}
      <Link
        href="/articles"
        className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/articles", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("articles")}
        <span
          className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/articles", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* end blogs */}
      <Link
        href="/agents"
        className={`hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/agents", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("agents")}
        <span
          className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/agents", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
      {/* start contact */}
      <Link
        href="/contact"
        className={` hover:text-secondary relative transition-all duration-300 ease-in-out ${
          isActive("/contact", pathname)
            ? "text-secondary font-extrabold"
            : "text-white font-medium"
        }`}
      >
        {t("contact")}
        <span
          className={`absolute -bottom-1 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
            isActive("/contact", pathname) ? "scale-x-100" : "text-white"
          }`}
        ></span>
      </Link>
    </div>
  );
}
