"use client";

import { createVendor, setSiteSettings } from "@/actions/cookies";
import fetchData from "@/api/fetch-data";
import Cart from "@/app/ui/cart/Cart";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import NavbarSheet from "@/app/ui/shared/NavbarSheet";
import { STALE_TIME } from "@/constants";
import { useSettings } from "@/stores/settings";
import { useQuery } from "@tanstack/react-query";
import clsx from "clsx";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect } from "react";
import { FaRegHeart } from "react-icons/fa";
import LangSwitcherRedesignThree from "./LangSwitcherRedesignThree";
import LoginPopoverRedesignThree from "./LoginPopoverRedesignThree";
import NavLinks from "./NavLinks";
import SearchBoxRedesignThree from "./SearchBoxRedesignThree";
import UserDropdownRedesignThree from "./UserDropdownRedesignThree";
import CategoriesMenuRedesignThree from "./CategoriesMenuRedesignThree";

export const isActive = (path, pathname) => pathname === path;

export default function RedesignThreeNavbar({ profile, settingsResponse }) {
  const t = useTranslations("navbar");
  const locale = useLocale();

  const { data, isLoading } = useQuery({
    queryKey: ["/links", locale],
    queryFn: () => fetchData({ endPoint: "/links" }),
    staleTime: STALE_TIME.LONG,
  });

  const { setSettings } = useSettings();
  const pathname = usePathname(); // Get current path

  useEffect(() => {
    createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    setSettings(settingsResponse);
    if (settingsResponse?.status == "dynamic") {
      setSiteSettings({
        siteSetting: settingsResponse?.site_settings,
        images: settingsResponse?.images,
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [locale]);
  return (
    <nav className="relative bg-main">
      {/* nav and logo */}
      <div className="border-b border-gray-600 bg-white">
        <div className="flex container justify-between items-center gap-5">
          {/* location and language switcher */}
          {/* start of responsive  */}

          <Link href="/" className="block lg:hidden">
            <FallbackImage
              src={settingsResponse?.images?.header}
              alt="logo"
              width={200}
              height={80}
              className="w-[200px] h-[80px]"
            />
          </Link>

          {/* end of responsive  */}
          {/* large screen */}
          <div className="block lg:hidden">
            <CategoriesMenuRedesignThree />
          </div>
          {/* nav */}
          <div
            className={`duration-500 hidden lg:block z-50 ease-in transition-all py-1 text-main w-full`}
          >
            {/* logo */}
            <div className={`flex items-center justify-between gap-6`}>
              <div className="lg:block hidden ">
                <Link href="/">
                  <FallbackImage
                    src={settingsResponse?.images?.header}
                    alt="logo"
                    width={200}
                    height={80}
                    className="w-[200px] h-[80px]"
                  />
                </Link>
              </div>
              {/* searchbox */}
              <div className="w-[60%] hidden lg:flex items-center gap-2">
                <SearchBoxRedesignThree />
              </div>
              <div className="flex items-center gap-8">
                {/* start wishlist */}
                <Link
                  href="/wishlist"
                  className={clsx(
                    `font-extrabold  hover:text-secondary space-y-2 text-base`,
                    {
                      "text-secondary": isActive("/wishlist", pathname),
                    }
                  )}
                >
                  <FaRegHeart size={20} className="mx-auto block" />
                  <p className="text-center text-xs">{t("wishlist")}</p>
                </Link>
                {/* end wishlist */}
                {/* start cart */}
                <div className=" font-extrabold hover:text-secondary">
                  <Cart profile={profile} />
                </div>
                {/* end cart */}
                {/* start sign in and profile */}
                <div
                  className={clsx("font-extrabold", {
                    "text-secondary": pathname.startsWith("/sign-in"),
                  })}
                >
                  {!profile ? (
                    <LoginPopoverRedesignThree />
                  ) : (
                    <div className="hidden lg:block">
                      <UserDropdownRedesignThree user={profile} />
                    </div>
                  )}
                </div>
                {/* end sign in and profile */}
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* navs and routes */}
      <div className="hidden lg:block">
        <div
          className={`flex items-center justify-between container gap-6 mt-0.5`}
        >
          {/* nav links */}
          <NavLinks data={data} isLoading={isLoading} />

          <LangSwitcherRedesignThree languages={settingsResponse?.languages} />
        </div>
      </div>

      {/* mobile nav */}
      <div className="block lg:hidden">
        <NavbarSheet
          profile={profile}
          data={data}
          isLoading={isLoading}
          pathname={pathname}
        />
      </div>
    </nav>
  );
}
