"use client";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import {
  HoverCard,
  HoverCardContent,
  HoverCardTrigger,
} from "@/components/ui/hover-card";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { FaBars } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowDown, IoIosArrowForward } from "react-icons/io";

import fetchData from "@/api/fetch-data";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import { useEffect, useState } from "react";
import { Separator } from "@/components/ui/separator";
export default function CategoriesMenuRedesignTwo({ img }) {
  const locale = useLocale();
  const [showDropdown, setShowDropdown] = useState(false);
  const [categories, setCategories] = useState([]);
  const t = useTranslations("navbar");

  useEffect(() => {
    async function getCategories() {
      const response = await fetchData({ endPoint: "/categories", locale });
      if (response?.status == "success") {
        setCategories(response?.data || []);
      }
    }
    getCategories();
  }, [locale]);

  return (
    <div>
      <DropdownMenu
        open={showDropdown}
        onOpenChange={setShowDropdown}
        modal={false}
      >
        <DropdownMenuTrigger className="lg:w-60 flex items-center gap-3  text-white text-lg font-bold  cursor-pointer ">
          <FaBars size={18} />
          {t("categories")}
          <IoIosArrowDown className=" ms-auto" />
        </DropdownMenuTrigger>
        {categories?.length == 0 ? (
          <DropdownMenuContent className="w-48  rounded-none  p-4 ">
            <p className="text-center">{t("no-sections")}</p>
          </DropdownMenuContent>
        ) : (
          <DropdownMenuContent className="w-60 mt-5 rounded-none rounded-b-sm px-0   max-md:max-h-64 max-md:overflow-y-auto ">
            {categories?.slice(0, 4)?.map((item, index) => (
              <HoverCard key={index} openDelay={100} closeDelay={100}>
                <HoverCardTrigger onClick={() => setShowDropdown(false)}>
                  <Link
                    href={`/products/filter/${item.id}`}
                    className="group  flex p-2 py-4 items-center gap-1  hover:text-secondary text-sm cursor-pointer"
                    dir={locale == "en" ? "ltr" : "rtl"}
                  >
                    <FallbackImage
                      src={item.cover_image || img}
                      alt={item.title}
                      width={30}
                      height={30}
                      className="me-auto"
                    />
                    <p className="text-base line-clamp-1">{item.title}</p>
                    {locale == "en" ? (
                      <IoIosArrowForward className="duration-500 group-hover:rotate-90 hover:text-secondary" />
                    ) : (
                      <IoIosArrowBack className="duration-500 group-hover:-rotate-90 hover:text-secondary" />
                    )}
                  </Link>
                  <Separator className="h-[1px] w-[95%] m-auto bg-gray-400" />
                </HoverCardTrigger>
                <HoverCardContent
                  className={`p-0 lg:absolute ${locale == "ar" ? "lg:end-[120px]" : "lg:start-[120px]"
                    } -top-7 rounded-none`}
                >
                  {item.sub_categories?.length == 0 ? (
                    <p className="text-center">{t("no-sections")}</p>
                  ) : (
                    <ul
                      dir={locale == "en" ? "ltr" : "rtl"}
                    >
                      {item?.sub_categories?.map((item, index) => (
                        <div key={index}>
                          <li
                            onClick={() => setShowDropdown(false)}
                            className="flex p-2 py-4 items-center"
                          >
                            <Link
                              href={`/products/filter/${item.id}`}
                              className=" hover:text-secondary"
                            >
                              {item.title}
                            </Link>
                            <FallbackImage
                              priority={true}
                              src={item.cover_image || img}
                              alt={item.title}
                              width={24}
                              height={24}
                              className="ms-auto"
                            />
                          </li>
                          <Separator className="h-[1px] w-[95%] m-auto bg-gray-400" />

                        </div>

                      ))}
                    </ul>
                  )}
                </HoverCardContent>
              </HoverCard>
            ))}
            <div className="w-fit hover:text-secondary m-auto ">
              <Link
                href={"/categories"}
                onClick={() => setShowDropdown(false)}
                className=" flex gap-1  py-2 group items-center justify-center"
              >
                {t("allcategories")}
              </Link>
            </div>
          </DropdownMenuContent>
        )}
      </DropdownMenu>
    </div>
  );
}