"use client";

import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { setUserLocale } from "@/services/locale";
import { useLocale } from "next-intl";
import { useTransition } from "react";

export default function LangSwitcherRedsignTwo({ languages }) {
  const locale = useLocale();
  const [isPending, startTransition] = useTransition();

  const toggleLanguage = (value) => {
    const newLocale = value; // Get the selected value
    startTransition(() => {
      setUserLocale(newLocale);
    });
  };

  return (
    <Select
      dir={locale == "en" ? "ltr" : "rtl"}
      disabled={isPending}
      value={locale}
      onValueChange={toggleLanguage}
    >
      <SelectTrigger className="text-lg bg-transparent w-fit text-white border-none  focus:ring-0 focus:ring-transparent focus:ring-offset-0">
        <SelectValue />
      </SelectTrigger>
      <SelectContent className="z-[101]">
        {languages?.map((item) => (
          <SelectItem key={item?.id} value={item?.code} className="text-lg">
            <p>{item?.title}</p>
          </SelectItem>
        ))}
      </SelectContent>
    </Select>
  );
}
