import {
  HoverCard,
  HoverCardContent,
  HoverCardTrigger,
} from "@/components/ui/hover-card";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { FiUser } from "react-icons/fi";

export default function LoginPopoverRedsignTwo({ sheet = false }) {
  const t = useTranslations("navbar");

  return (
    <HoverCard openDelay={0} closeDelay={200}>
      <HoverCardTrigger
        className={`text-base font-normal flex  cursor-pointer py-4  ${
          sheet == true
            ? "justify-center flex-col items-center text-[14px] mx-auto"
            : "text-base font-normal flex items-center gap-2 cursor-pointer"
        }`}
      >
        <FiUser size={25} className="text-white" />
        {t("sign-in")}
      </HoverCardTrigger>
      <HoverCardContent className="w-80  flex flex-col data-[state=closed]:zoom-out-0 data-[state=open]:zoom-in-0">
        <Link
          href="/sign-in"
          className="text-main p-3 hover:bg-slate-100 hover:scale-105 duration-150 rounded-lg w-full"
        >
          {t("sign-in")}
        </Link>
        <Link
          href="/sign-in-vendor"
          className="text-main p-3 hover:bg-slate-100 hover:scale-105 duration-150 rounded-lg w-full"
        >
          {t("sign-in-vendor")}
        </Link>
        <Link
          href="/sign-up-vendor"
          className="text-main p-3 hover:bg-slate-100 hover:scale-105 duration-150 rounded-lg w-full"
        >
          {t("sign-up-vendor")}
        </Link>
        <Link
          href="/sign-up-affiliate"
          className="text-main p-3 hover:bg-slate-100 hover:scale-105 duration-150 rounded-lg w-full"
        >
          {t("sign-up-affiliate")}
        </Link>
      </HoverCardContent>
    </HoverCard>
  );
}
