"use client";

import { createVendor } from "@/actions/cookies";
import Cart from "@/app/ui/cart/Cart";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import NavbarSheet from "@/app/ui/shared/NavbarSheet";
import { Separator } from "@/components/ui/separator";
import { useSettings } from "@/stores/settings";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect, useState } from "react";
import {
  FaFacebookF,
  FaInstagram,
  FaRegHeart,
  FaSnapchatGhost,
  FaYoutube,
} from "react-icons/fa";
import { TfiHeadphoneAlt } from "react-icons/tfi";
import LoginPopoverRedsignTwo from "./LoginPopoverRedsignTwo";
import UserDropdown from "./UserDropdown";
import { FaXTwitter } from "react-icons/fa6";
import CurrencySwitcherRedesignTwo from "./CurrencySwitcherRedesignTwo";
import LangSwitcherRedsignTwo from "./LangSwitcherRedsignTwo";
import CategoriesMenuRedesignTwo from "./CategoriesMenuRedesignTwo";

import StyleFiveSearchBox from "./StyleFiveSearchBox";

export default function RedesignTwoNavbar({
  profile,
  currenciesResponse,
  settingsResponse,
}) {
  const t = useTranslations("navbar");
  const pathname = usePathname(); // Get current path
  const [isVisible, setIsVisible] = useState(false);

  const isActive = (path) => pathname === path;
  const { setSettings } = useSettings();
  useEffect(() => {
    async function setVendorPermission() {
      await createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    }
    setVendorPermission();
  }, [settingsResponse?.site_settings?.is_multi_vendor]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  useEffect(() => {
    const toggleVisibility = () => {
      if (window.scrollY > 60) {
        setIsVisible(true);
      } else {
        setIsVisible(false);
      }
    };

    window.addEventListener("scroll", toggleVisibility);
    return () => window.removeEventListener("scroll", toggleVisibility);
  }, []);

  return (
    <nav className="relative top-0 start-0 end-0 bg-main ">
      {/* app and info */}
      <div className="bg-main border-b  ">
        <div className="container flex items-center  justify-center">
          {/* currency and language switchers */}
          <div className="flex items-center justify-between w-full">
            <div className="flex items-center  ">
              {/* currency */}
              <CurrencySwitcherRedesignTwo
                response={currenciesResponse}
                profile={profile}
              />
              {/* langSwitcher */}
              <LangSwitcherRedsignTwo
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
            </div>
            {/* social */}
            {settingsResponse?.site_settings?.show_social_icons == 1 ? (
              <div className="flex items-center gap-4 justify-center md:justify-start text-white">
                <Link
                  href={
                    settingsResponse?.site_settings?.facebook_url ||
                    siteSettingFallback?.site_settings?.facebook_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaFacebookF size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.youtube_url ||
                    siteSettingFallback?.site_settings?.youtube_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaYoutube size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.instagram_url ||
                    siteSettingFallback?.site_settings?.instagram_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaInstagram size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.twitter_url ||
                    siteSettingFallback?.site_settings?.twitter_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaXTwitter size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.snapchat_url ||
                    siteSettingFallback?.site_settings?.snapchat_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaSnapchatGhost size={20} />
                </Link>
              </div>
            ) : (
              ""
            )}
          </div>
        </div>
      </div>
      {/* nav and logo */}
      <div className=" py-3 border-b border-gray-300">
        <div className="container flex lg:justify-between justify-center items-center gap-6">
          {/* location and language switcher */}
          {/* start of responsive  */}

          <Link href="/" className="block lg:hidden">
            <FallbackImage
              src={
                settingsResponse?.images?.header ||
                siteSettingFallback?.images?.header
              }
              alt="logo"
              width={80}
              height={80}
            />
          </Link>

          {/* sheet */}
          <div className="block lg:hidden">
            <NavbarSheet profile={profile} />
          </div>
          {/* end of responsive  */}
          {/* large screen */}

          {/* nav */}
          <div className="text-white hidden lg:flex items-center justify-between gap-10  w-full">
            {/* logo */}
            <div className="lg:block hidden ">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={100}
                  height={100}
                />
              </Link>
            </div>

            {/* searchbox */}
            <div className="w-1/2 hidden lg:flex items-center gap-2">
              <StyleFiveSearchBox />
            </div>

            <div className="flex items-center gap-8">
              {/* phone */}
              {settingsResponse?.site_settings?.phone1 && (
                <div className="hidden lg:flex items-center gap-2 ">
                  <div className="size-10 flex items-center justify-center bg-white rounded-full">
                    <TfiHeadphoneAlt size={30} className="text-main" />
                  </div>
                  <div className="text-white">
                    <p className="text-sm ">{t("contact")}</p>
                    <p className="text-lg font-semibold ">
                      {settingsResponse?.site_settings?.phone1 ||
                        siteSettingFallback?.site_settings?.phone1}{" "}
                    </p>
                  </div>
                </div>
              )}
              {/* start sign in and profile */}
              {!profile ? (
                <LoginPopoverRedsignTwo />
              ) : (
                <div className="hidden lg:block">
                  <UserDropdown user={profile} />
                </div>
              )}
              {/* end sign in and profile */}
              {/* start cart */}
              <div className="text-white">
                <Cart profile={profile} />
              </div>
              {/* end cart */}
            </div>
          </div>
        </div>
      </div>
      {/* navs and routes */}
      <div
        className={`hidden bg-main ${
          isVisible ? "top-0 z-50 fixed w-full px-32 left-0" : ""
        } lg:block w-full`}
      >
        <div
          className={`flex items-center bg-inherit duration-700 gap-6`}
        >
          {/* start categories */}
          <CategoriesMenuRedesignTwo
            img={
              settingsResponse?.images?.not_found || "/products/Placeholder.png"
            }
          />
          <Separator orientation="vertical" className="h-8 bg-gray-300" />
          <div className="flex items-center gap-6 py-4">
            {/* start home */}
            <Link
              href="/"
              className={`py-2 text-base  font-bold relative transition-all duration-300 ease-in-out ${
                isActive("/") ? "text-secondary font-extrabold" : "text-white"
              }`}
            >
              {t("home")}
              <span
                className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                  isActive("/") ? "scale-x-100" : "text-white"
                }`}
              ></span>
            </Link>
            {/* end home */}
            {/* start about-us */}
            <Link
              href="/about-us"
              className={`py-2 text-base  font-bold relative transition-all duration-300 ease-in-out ${
                isActive("/about-us")
                  ? "text-secondary font-extrabold"
                  : "text-white"
              }`}
            >
              {t("about-us")}
              <span
                className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                  isActive("/about-us") ? "scale-x-100" : "text-white"
                }`}
              ></span>
            </Link>
            {/* end about-us */}
            {/* start brands */}
            <Link
              href="/brands"
              className={`py-2 text-base  font-bold relative transition-all duration-300 ease-in-out ${
                isActive("/brands")
                  ? "text-secondary font-extrabold"
                  : "text-white"
              }`}
            >
              {t("marks")}
              <span
                className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                  isActive("/brands") ? "scale-x-100" : "text-white"
                }`}
              ></span>
            </Link>
            {/* end brands */}
            {/* start offers */}
            <Link
              href="/offers"
              className={`py-2 text-base  font-bold relative transition-all duration-300 ease-in-out text-secondary ${
                isActive("/offers")
                  ? "text-secondary font-extrabold"
                  : "text-white"
              }`}
            >
              {t("shows")}
              <span
                className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                  isActive("/offers") ? "scale-x-100" : "text-white"
                }`}
              ></span>
            </Link>
            {/* end offers */}
            {/* start blogs */}
            <Link
              href="/articles"
              className={`py-2 text-base  font-bold relative transition-all duration-300 ease-in-out ${
                isActive("/articles")
                  ? "text-secondary font-extrabold"
                  : "text-white"
              }`}
            >
              {t("blogs")}
              <span
                className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                  isActive("/articles") ? "scale-x-100" : "text-white"
                }`}
              ></span>
            </Link>
            {/* end blogs */}
            {/* start contact */}
            <Link
              href="/contact"
              className={`py-2 text-base  font-bold relative transition-all duration-300 ease-in-out ${
                isActive("/contact")
                  ? "text-secondary font-extrabold"
                  : "text-white"
              }`}
            >
              {t("contact")}
              <span
                className={`absolute bottom-0 start-0 w-[70%] h-0.5 bg-secondary transform scale-x-0 transition-all duration-900 ease-in-out ${
                  isActive("/contact") ? "scale-x-100" : "text-white"
                }`}
              ></span>
            </Link>
            {/* end contact */}
          </div>

          <div className="flex items-center gap-6 ms-auto">
            <Separator orientation="vertical" className="h-8 bg-gray-300" />
            {/* start wishlist */}
            <Link
              href="/wishlist"
              className={` font-bold text-white flex items-center gap-2 text-base ${
                isActive("/wishlist") ? "text-secondary font-extrabold" : ""
              }`}
            >
              <FaRegHeart size={25} className="" />
              {t("wishlist")}
            </Link>
            {/* end wishlist */}
          </div>
        </div>
      </div>
    </nav>
  );
}
