"use client";

import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { setUserLocale } from "@/services/locale";
import { useLocale } from "next-intl";
import { useTransition } from "react";

export default function LangSwitcherFive({ languages }) {
  const locale = useLocale();
  const [isPending, startTransition] = useTransition();

  const toggleLanguage = (value) => {
    const newLocale = value; // Get the selected value
    startTransition(() => {
      setUserLocale(newLocale);
    });
  };

  return (
    <Select
      dir={locale == "en" ? "ltr" : "rtl"}
      disabled={isPending}
      value={locale}
      onValueChange={toggleLanguage}
    >
      <SelectTrigger className="text-white border-none bg-transparent focus:ring-0 focus:ring-transparent focus:ring-offset-0">
        <SelectValue />
      </SelectTrigger>
      <SelectContent className="z-[101]">
        {languages?.map((item) => (
          <SelectItem key={item?.id} value={item?.code}>
            <p>{item?.title}</p>
          </SelectItem>
        ))}
      </SelectContent>
    </Select>
  );
}
