"use client";

import { createVendor } from "@/actions/cookies";
import Cart from "@/app/ui/cart/Cart";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import LoginPopover from "@/app/ui/shared/LoginPopover";
import NavbarSheet from "@/app/ui/shared/NavbarSheet";
import UserDropdown from "@/app/ui/shared/UserDropdown";
import { Separator } from "@/components/ui/separator";
import { useSettings } from "@/stores/settings";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect } from "react";
import {
  FaFacebookF,
  FaInstagram,
  FaRegHeart,
  FaSnapchatGhost,
  FaYoutube,
} from "react-icons/fa";
import { TfiHeadphoneAlt } from "react-icons/tfi";

import { FaXTwitter } from "react-icons/fa6";
import CurrencySwitcherFive from "./CurrencySwitcherFive";
import LangSwitcherFive from "./LangSwitcherFive";
import StyleFiveCategoriesMenu from "./StyleFiveCategoriesMenu";
import StyleFiveSearchBox from "./StyleFiveSearchBox";
import CartRedesignTwo from "@/app/ui/cart/CartRedesignTwo";

export default function RedesignNavbar({
  profile,
  currenciesResponse,
  settingsResponse,
}) {
  const t = useTranslations("navbar");
  const pathname = usePathname(); // Get current path

  const isActive = (path) => pathname === path; // Helper to check active path
  const { setSettings } = useSettings();
  useEffect(() => {
    async function setVendorPermission() {
      await createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    }
    setVendorPermission();
  }, [settingsResponse?.site_settings?.is_multi_vendor]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  return (
    <nav className="relative top-0 start-0 end-0 bg-white ">
      {/* app and info */}
      <div className="bg-black ">
        <div className="container flex items-center  justify-center">
          {/* currency and language switchers */}
          <div className="flex items-center justify-between w-full">
            <div className="flex items-center gap-2 md:gap-4 lg:gap-6">
              {/* currency */}
              <CurrencySwitcherFive
                response={currenciesResponse}
                profile={profile}
              />
              {/* langSwitcher */}
              <LangSwitcherFive
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
            </div>
            {/* social */}
            {settingsResponse?.site_settings?.show_social_icons == 1 ? (
              <div className="flex items-center gap-4 justify-center md:justify-start text-white">
                <Link
                  href={
                    settingsResponse?.site_settings?.facebook_url ||
                    siteSettingFallback?.site_settings?.facebook_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaFacebookF size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.youtube_url ||
                    siteSettingFallback?.site_settings?.youtube_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaYoutube size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.instagram_url ||
                    siteSettingFallback?.site_settings?.instagram_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaInstagram size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.twitter_url ||
                    siteSettingFallback?.site_settings?.twitter_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaXTwitter size={20} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.snapchat_url ||
                    siteSettingFallback?.site_settings?.snapchat_url
                  }
                  className=" hover:scale-105 transition-all duration-300"
                >
                  <FaSnapchatGhost size={20} />
                </Link>
              </div>
            ) : (
              ""
            )}
          </div>
        </div>
      </div>
      {/* nav and logo */}
      <div className=" py-6 border-b border-gray-300">
        <div className="container flex justify-between items-center gap-6">
          {/* location and language switcher */}
          {/* start of responsive  */}
          <div className="text-black flex md:hidden items-center justify-between max-md:w-full gap-2 md:gap-4">
            <div className=" flex items-center justify-center w-full">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={80}
                  height={80}
                />
              </Link>
            </div>
          </div>
          {/* sheet */}
          <div className="block lg:hidden">
            <NavbarSheet profile={profile} />
          </div>
          {/* end of responsive  */}
          {/* large screen */}

          {/* nav */}
          <div className="text-black hidden lg:flex items-center justify-between gap-10  w-full">
            {/* logo */}
            <div className="lg:block hidden ">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={100}
                  height={100}
                />
              </Link>
            </div>

            {/* searchbox */}
            <div className="w-1/2 hidden lg:flex items-center gap-2">
              <StyleFiveSearchBox />
            </div>

            <div className="flex items-center gap-8">
              {/* phone */}
              {settingsResponse?.site_settings?.phone1 && (
                <div className="hidden lg:flex items-center gap-2 ">
                  <div className="size-10 flex items-center justify-center bg-white rounded-full">
                    <TfiHeadphoneAlt size={30} className="text-main" />
                  </div>
                  <div>
                    <p className="text-sm ">{t("contact")}</p>
                    <p className="text-lg font-semibold text-main">
                      {settingsResponse?.site_settings?.phone1 ||
                        siteSettingFallback?.site_settings?.phone1}{" "}
                    </p>
                  </div>
                </div>
              )}
              {/* start sign in and profile */}
              {!profile ? (
                <LoginPopover />
              ) : (
                <div className="hidden lg:block">
                  <UserDropdown user={profile} />
                </div>
              )}
              {/* end sign in and profile */}
              {/* start cart */}
              <CartRedesignTwo profile={profile} />
              {/* end cart */}
            </div>
          </div>
        </div>
      </div>
      {/* navs and routes */}
      <div className="  hidden lg:block container bg">
        <div className=" hidden lg:flex items-center gap-6 w-full ">
          {/* start categories */}
          <StyleFiveCategoriesMenu
            img={
              settingsResponse?.images?.not_found || "/products/Placeholder.png"
            }
          />
          <Separator orientation="vertical" className="h-8 bg-gray-300" />
          <div className="flex items-center gap-6 py-4">
            {/* start home */}
            <Link
              href="/"
              className={`py-2 text-base font-bold ${
                isActive("/") ? "text-main font-extrabold " : ""
              }`}
            >
              {t("home")}
            </Link>
            {/* end home */}
            {/* start about-us */}
            <Link
              href="/about-us"
              className={`text-base font-bold py-2 ${
                isActive("/about-us") ? "text-main font-extrabold" : ""
              }`}
            >
              {t("about-us")}
            </Link>
            {/* end about-us */}
            {/* start brands */}
            <Link
              href="/brands"
              className={` py-2 text-base font-bold ${
                isActive("/brands") ? "text-main font-extrabold" : ""
              }`}
            >
              {t("marks")}
            </Link>
            {/* end brands */}
            {/* start offers */}
            <Link
              href="/offers"
              className={`py-2 text-base font-bold ${
                isActive("/offers") ? "text-main font-extrabold" : ""
              }`}
            >
              {t("shows")}
            </Link>
            {/* end offers */}
            {/* start blogs*/}
            <Link
              href="/articles"
              className={`py-2 text-base font-bold ${
                isActive("/articles") ? "text-main font-extrabold" : ""
              }`}
            >
              {t("blogs")}
            </Link>
            {/* end blogs*/}
            {/* start blogs*/}
            <Link
              href="/contact"
              className={`py-2 text-base font-bold ${
                isActive("/contact") ? "text-main font-extrabold" : ""
              }`}
            >
              {t("contact")}
            </Link>
            {/* end blogs*/}
          </div>
          <div className="flex items-center gap-6 ms-auto">
            <Separator orientation="vertical" className="h-8 bg-gray-300" />
            {/* start wishlist */}
            <Link
              href="/wishlist"
              className={` font-bold flex items-center gap-2 text-base ${
                isActive("/wishlist") ? "text-main font-extrabold" : ""
              }`}
            >
              <FaRegHeart size={20} className="text-main" />
              {t("wishlist")}
            </Link>
            {/* end wishlist */}
          </div>
        </div>
      </div>
    </nav>
  );
}
