"use client";

import {
  createVendor,
  getUserPermissions,
  setUserPermissions,
} from "@/actions/cookies";
import Cart from "@/app/ui/cart/Cart";
import CurrencySwitcher from "@/app/ui/shared/CurrencySwitcher";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import LangSwitcher from "@/app/ui/shared/LangSwitcher";
import NavbarSheet from "@/app/ui/shared/NavbarSheet";
import UserDropdown from "@/app/ui/shared/UserDropdown";
import { Separator } from "@/components/ui/separator";
import { useSettings } from "@/stores/settings";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect } from "react";
import {
  FaFacebookF,
  FaInstagram,
  FaRegHeart,
  FaSnapchatGhost,
  FaYoutube,
} from "react-icons/fa";
import { FaPhoneFlip, FaXTwitter } from "react-icons/fa6";
import { GoMail } from "react-icons/go";
import LoginPopover from "@/app/ui/shared/LoginPopover";
import StyleOneCategoriesMenu from "./StyleOneCategoriesMenu";
import StyleOneSearchBox from "./StyleOneSearchBox";
import { siteSettingFallback } from "@/lib/utils";

export default function StyleOneNavBarUi({
  token,
  profile,
  currenciesResponse,
  settingsResponse,
}) {
  const t = useTranslations("navbar");
  const pathname = usePathname(); // Get current path

  const isActive = (path) => pathname === path; // Helper to check active path
  const { setSettings } = useSettings();

  useEffect(() => {
    async function setVendorPermission() {
      if (profile) {
        const cookieExist = await getUserPermissions();
        if (!cookieExist) {
          await setUserPermissions({
            is_affiliate: profile.is_affiliate,
            is_vendor: profile.is_vendor,
          });
        }
      }
      await createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    }
    setVendorPermission();
  }, [profile, settingsResponse?.site_settings?.is_multi_vendor]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  return (
    <nav className="relative top-0 start-0 end-0 bg-white ">
      {/* app and info */}
      <div className=" border-b border-gray-300 ">
        <div className="container py-3 space-x-1 flex items-center  justify-center">
          {/* logo or mail */}
          <div className="lg:hidden max-md:hidden mx-2 block">
            <Link href="/">
              <FallbackImage
                src={
                  settingsResponse?.images?.header ||
                  siteSettingFallback?.images?.header
                }
                alt="logo"
                width={70}
                height={70}
              />
            </Link>
          </div>

          {/* currency and language switchers */}
          <div className="text-black flex items-center justify-between max-md:hidden gap-2 md:gap-4">
            {/* currency */}
            <CurrencySwitcher response={currenciesResponse} />
            {/* langSwitcher */}
            <LangSwitcher
              languages={
                settingsResponse?.languages || siteSettingFallback?.languages
              }
            />
            {/* social */}
            {settingsResponse?.site_settings?.show_social_icons == 1 ? (
              <div className="flex items-center gap-4 justify-center md:justify-start">
                <Link
                  href={
                    settingsResponse?.site_settings?.facebook_url ||
                    siteSettingFallback?.site_settings?.facebook_url
                  }
                  className=" hover:text-blue-600 transition-all duration-300"
                >
                  <FaFacebookF size={24} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.youtube_url ||
                    siteSettingFallback?.site_settings?.youtube_url
                  }
                  className=" hover:text-red-600 transition-all duration-300"
                >
                  <FaYoutube size={24} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.instagram_url ||
                    siteSettingFallback?.site_settings?.instagram_url
                  }
                  className="hover:text-purple-600 transition-all duration-300"
                >
                  <FaInstagram size={24} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.twitter_url ||
                    siteSettingFallback?.site_settings?.twitter_url
                  }
                  className="transition-all duration-300"
                >
                  <FaXTwitter size={24} />
                </Link>
                <Link
                  href={
                    settingsResponse?.site_settings?.snapchat_url ||
                    siteSettingFallback?.site_settings?.snapchat_url
                  }
                  className="hover:text-yellow-400 transition-all duration-300"
                >
                  <FaSnapchatGhost size={24} />
                </Link>
              </div>
            ) : (
              ""
            )}
          </div>
        </div>
      </div>
      {/* nav and logo */}
      <div className=" py-6">
        <div className="container flex justify-between items-center gap-6">
          {/* location and language switcher */}
          {/* start of responsive  */}
          <div className="text-black flex md:hidden items-center justify-between max-md:w-full gap-2 md:gap-4">
            <div className=" flex">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={80}
                  height={80}
                />
              </Link>
            </div>
            <div className="flex items-center">
              {/* currency */}
              <CurrencySwitcher response={currenciesResponse} />
              {/* langSwitcher */}
              <LangSwitcher
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
            </div>
          </div>
          {/* sheet */}
          <div className="block lg:hidden">
            <NavbarSheet profile={profile} />
          </div>
          {/* end of responsive  */}
          {/* large screen */}

          {/* nav */}
          <div className="text-black hidden lg:flex items-center justify-between gap-10  w-full">
            {/* logo */}
            <div className="lg:block hidden">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={100}
                  height={100}
                />
              </Link>
            </div>
            {/* phone */}
            {settingsResponse?.site_settings?.phone1 && (
              <div className="hidden lg:flex items-center gap-2 me-4">
                <div className="size-10 flex items-center justify-center bg-white rounded-full">
                  <FaPhoneFlip size={24} className="text-main" />
                </div>
                <div>
                  <p className="text-sm ">{t("contact")}</p>
                  <p className="text-base font-semibold">
                    {settingsResponse?.site_settings?.phone1 ||
                      siteSettingFallback?.site_settings?.phone1}
                  </p>
                </div>
              </div>
            )}

            {/* searchbox */}
            <div className="w-1/2 hidden lg:flex items-center gap-2">
              <StyleOneSearchBox />
              <StyleOneCategoriesMenu />
            </div>

            <div className="flex items-center gap-3">
              {/* start cart */}
              <Cart profile={profile} />
              {/* end cart */}
              {/* start wishlist */}
              <Separator orientation="vertical" className="h-6 bg-gray-300" />
              <Link
                href="/wishlist"
                className={`flex items-center gap-2 text-base ${
                  isActive("/wishlist") ? "text-main font-bold" : ""
                }`}
              >
                <FaRegHeart size={20} className="text-main" />
                {t("wishlist")}
              </Link>
              {/* end wishlist */}
              {/* start sign in and profile */}
              <Separator orientation="vertical" className="h-6 bg-gray-300" />
              {!token ? (
                <LoginPopover />
              ) : (
                <div className="hidden lg:block">
                  <UserDropdown user={profile} />
                </div>
              )}
              {/* end sign in and profile */}
            </div>
          </div>
        </div>
      </div>
      {/* navs and routes */}
      <div className="bg-main py-4 hidden lg:block">
        <div className="text-white hidden lg:flex items-center justify-center gap-6 container">
          {/* start home */}
          <Link
            href="/"
            className={`py-2 text-base font-bold ${
              isActive("/") ? "border-b border-white font-extrabold " : ""
            }`}
          >
            {t("home")}
          </Link>
          {/* end home */}
          {/* start about-us */}
          <Link
            href="/about-us"
            className={`text-base font-bold py-2 ${
              isActive("/about-us")
                ? "border-b  border-white font-extrabold"
                : ""
            }`}
          >
            {t("about-us")}
          </Link>
          {/* end about-us */}
          {/* start brands */}
          <Link
            href="/brands"
            className={` py-2 text-base font-bold ${
              isActive("/brands") ? "border-b border-white font-extrabold" : ""
            }`}
          >
            {t("marks")}
          </Link>
          {/* end brands */}
          {/* start offers */}
          <Link
            href="/offers"
            className={`py-2 text-base font-bold ${
              isActive("/offers") ? "border-b border-white font-extrabold" : ""
            }`}
          >
            {t("shows")}
          </Link>
          {/* end offers */}
          {/* start blogs*/}
          <Link
            href="/articles"
            className={`py-2 text-base font-bold ${
              isActive("/articles")
                ? "border-b border-white font-extrabold"
                : ""
            }`}
          >
            {t("blogs")}
          </Link>
          {/* end blogs*/}
          {/* start blogs*/}
          <Link
            href="/contact"
            className={`py-2 text-base font-bold ${
              isActive("/contact") ? "border-b border-white font-extrabold" : ""
            }`}
          >
            {t("contact")}
          </Link>
          {/* end blogs*/}
        </div>
      </div>
    </nav>
  );
}
