"use client";
import { createVendor } from "@/actions/cookies";
import Cart from "@/app/ui/cart/Cart";
import CurrencySwitcher from "@/app/ui/shared/CurrencySwitcher";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import LangSwitcher from "@/app/ui/shared/LangSwitcher";
import NavbarSheet from "@/app/ui/shared/NavbarSheet";
import UserDropdown from "@/app/ui/shared/UserDropdown";
import { Separator } from "@/components/ui/separator";
import { useSettings } from "@/stores/settings";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect } from "react";
import {
  FaFacebookF,
  FaInstagram,
  FaRegHeart,
  FaSnapchatGhost,
  FaYoutube,
} from "react-icons/fa";
import { FaPhoneFlip, FaXTwitter } from "react-icons/fa6";
import { GoMail } from "react-icons/go";
import { FiUser } from "react-icons/fi";
import StyleThreeSearchBox from "./StyleThreeSearchBox";
import StyleThreeCategoriesMenu from "./StyleThreeCategoriesMenu";
import { SelectSeparator } from "@/components/ui/select";
import LoginPopover from "@/app/ui/shared/LoginPopover";

export default function StyleThreeNavBarUi({
  token,
  profile,
  currenciesResponse,
  categoriesResponse,
  settingsResponse,
}) {
  const t = useTranslations("navbar");
  const pathname = usePathname(); // Get current path

  const isActive = (path) => pathname === path; // Helper to check active path
  const { setSettings } = useSettings();

  useEffect(() => {
    async function setVendorPermission() {
      await createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    }
    setVendorPermission();
  }, [settingsResponse?.site_settings?.is_multi_vendor]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  return (
    <nav className="relative top-0 start-0 end-0 bg-white ">
      {/* app and info */}
      <div className=" bg-main text-white">
        <div className="container py-2 flex items-center  justify-center">
          {/* logo or mail */}
          <div className="lg:hidden max-md:hidden mx-2 block">
            <Link href="/">
              <FallbackImage
                src={
                  settingsResponse?.images?.header ||
                  siteSettingFallback?.images?.header
                }
                alt="logo"
                width={70}
                height={70}
              />
            </Link>
          </div>
          {settingsResponse?.site_settings?.mail_url && (
            <div className="flex items-center gap-2">
              <a
                href={`mailto:${settingsResponse?.site_settings?.mail_url}`}
                className="flex items-center gap-2 "
              >
                <GoMail size={20} />
                {settingsResponse?.site_settings?.mail_url}
              </a>
              <Separator orientation="vertical" className="h-4 bg-white" />
              <a
                href={`mailto:${settingsResponse?.site_settings?.email}`}
                className=""
              >
                {settingsResponse?.site_settings?.email}
              </a>
            </div>
          )}
          {/* currency and language switchers */}
          <div className="text-black flex items-center justify-between max-md:hidden lg:hidden gap-2 md:gap-4">
            {/* currency */}
            <CurrencySwitcher response={currenciesResponse} />
            {/* langSwitcher */}
            <LangSwitcher
              languages={
                settingsResponse?.languages || siteSettingFallback?.languages
              }
            />
          </div>
        </div>
      </div>
      {/* nav and logo */}
      <div className=" py-6">
        <div className="container flex justify-between items-center gap-6">
          {/* location and language switcher */}
          {/* start of responsive  */}
          <div className="text-black flex md:hidden items-center justify-between max-md:w-full gap-2 md:gap-4">
            <div className=" flex">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={80}
                  height={80}
                />
              </Link>
            </div>
            <div className="flex items-center">
              {/* currency */}
              <CurrencySwitcher response={currenciesResponse} />
              {/* langSwitcher */}
              <LangSwitcher
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
            </div>
          </div>
          {/* sheet */}
          <div className="block lg:hidden">
            <NavbarSheet token={token} profile={profile} />
          </div>
          {/* end of responsive  */}
          {/* large screen */}
          {/* nav */}
          <div className="text-black hidden lg:flex items-center justify-between gap-10  w-full">
            {/* logo */}
            <div className="lg:block hidden">
              <Link href="/">
                <FallbackImage
                  src={settingsResponse?.images?.header}
                  alt="logo"
                  width={100}
                  height={100}
                />
              </Link>
            </div>
            {/* navs and routes */}
            <div className=" hidden lg:flex items-center justify-center gap-6 ">
              {/* start home */}
              <Link
                href="/"
                className={`py-2 text-base font-bold ${
                  isActive("/") ? "text-main font-extrabold " : ""
                }`}
              >
                {t("home")}
              </Link>
              {/* end home */}
              {/* start about-us */}
              <Link
                href="/about-us"
                className={`text-base font-bold py-2 ${
                  isActive("/about-us") ? "text-main font-extrabold" : ""
                }`}
              >
                {t("about-us")}
              </Link>
              {/* end about-us */}
              {/* start brands */}
              <Link
                href="/brands"
                className={` py-2 text-base font-bold ${
                  isActive("/brands") ? "text-main font-extrabold" : ""
                }`}
              >
                {t("marks")}
              </Link>
              {/* end brands */}
              {/* start offers */}
              <Link
                href="/offers"
                className={`py-2 text-base font-bold ${
                  isActive("/offers") ? "text-main font-extrabold" : ""
                }`}
              >
                {t("shows")}
              </Link>
              {/* end offers */}
              {/* start blogs*/}
              <Link
                href="/articles"
                className={`py-2 text-base font-bold ${
                  isActive("/articles") ? "text-main font-extrabold" : ""
                }`}
              >
                {t("blogs")}
              </Link>
              {/* end blogs*/}
              {/* start blogs*/}
              <Link
                href="/contact"
                className={`py-2 text-base font-bold ${
                  isActive("/contact") ? "text-main font-extrabold" : ""
                }`}
              >
                {t("contact")}
              </Link>
              {/* end blogs*/}
            </div>
            {/* currency and language switchers */}
            <div className="text-black flex items-center justify-between max-md:hidden gap-2 md:gap-4">
              {/* currency */}
              <CurrencySwitcher response={currenciesResponse} />
              <Separator orientation="vertical" className="h-4 bg-gray-300" />
              {/* langSwitcher */}
              <LangSwitcher
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
              {/* phone */}
              {settingsResponse?.site_settings?.phone1 && (
                <>
                  <Separator
                    orientation="vertical"
                    className="h-4 bg-gray-300"
                  />
                  <div className="flex items-center gap-2">
                    <FaPhoneFlip size={20} className="text-main" />
                    <p className="text-base font-semibold">
                      {settingsResponse?.site_settings?.phone1}{" "}
                    </p>
                  </div>
                </>
              )}
            </div>
          </div>
        </div>
      </div>
      {/* user & search*/}
      <div className="container pb-6 hidden lg:flex items-center  gap-8">
        {/* categories */}
        <StyleThreeCategoriesMenu />
        {/* searchbox */}
        <div className="grow hidden lg:flex items-center gap-2">
          <StyleThreeSearchBox />
        </div>
        {/* user and cart */}
        <div className="flex items-center gap-3">
          {/* start cart */}
          <Cart token={token} />
          {/* end cart */}
          {/* start wishlist */}
          <Separator orientation="vertical" className="h-6 bg-gray-300" />
          <Link
            href="/wishlist"
            className={`flex items-center gap-2 text-base ${
              isActive("/wishlist") ? "text-main font-bold" : ""
            }`}
          >
            <FaRegHeart size={20} className="text-main" />
            {t("wishlist")}
          </Link>
          {/* end wishlist */}
          {/* start sign in and profile */}
          <Separator orientation="vertical" className="h-6 bg-gray-300" />
          {!token ? (
            <LoginPopover />
          ) : (
            <div className="hidden lg:block">
              <UserDropdown user={profile} />
            </div>
          )}
          {/* end sign in and profile */}
        </div>
      </div>
    </nav>
  );
}
