"use client";

import { createVendor } from "@/actions/cookies";
import Cart from "@/app/ui/cart/Cart";
import CurrencySwitcher from "@/app/ui/shared/CurrencySwitcher";
import FallbackImage from "@/app/ui/shared/FallbackImage";
import LangSwitcher from "@/app/ui/shared/LangSwitcher";
import NavbarSheet from "@/app/ui/shared/NavbarSheet";
import UserDropdown from "@/app/ui/shared/UserDropdown";
import { Separator } from "@/components/ui/separator";
import { useSettings } from "@/stores/settings";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import for current path
import { useEffect } from "react";
import { FaRegHeart } from "react-icons/fa";
import { FaPhoneFlip } from "react-icons/fa6";
import { FiUser } from "react-icons/fi";
import LightBlueCategoriesMenu from "./LightBlueCategoriesMenu";
import LightBlueSearchBox from "./LightBlueSearchBox";
import LoginPopover from "@/app/ui/shared/LoginPopover";

export default function LightBlueNavBarUi({
  profile,
  currenciesResponse,
  categoriesResponse,
  settingsResponse,
}) {
  const t = useTranslations("navbar");
  const pathname = usePathname(); // Get current path

  const isActive = (path) => pathname === path; // Helper to check active path
  const { setSettings } = useSettings();

  useEffect(() => {
    async function setVendorPermission() {
      await createVendor(settingsResponse?.site_settings?.is_multi_vendor);
    }
    setVendorPermission();
  }, [settingsResponse?.site_settings?.is_multi_vendor]);

  useEffect(() => {
    setSettings(settingsResponse);
  }, [setSettings, settingsResponse]);

  return (
    <nav className="relative top-0 start-0 end-0 bg-lightmain ">
      {/* app and info */}
      <div className="">
        <div className="container hidden md:py-4 lg:flex items-center lg:justify-between justify-center lg:border-b lg:border-main lg:border-opacity-30">
          {/* logo */}
          <div className="lg:block hidden">
            <Link href="/">
              <FallbackImage
                src={
                  settingsResponse?.images?.header ||
                  siteSettingFallback?.images?.header
                }
                alt="logo"
                width={70}
                height={70}
              />
            </Link>
          </div>
          {/* nav tabs */}
          <div className="text-black hidden lg:flex items-center gap-6">
            {/* start home */}
            <Link
              href="/"
              className={`text-base text-semibold ${
                isActive("/") ? "text-main font-bold" : ""
              }`}
            >
              {t("home")}
            </Link>
            {/* end home */}
            {/* start about-us */}
            <Link
              href="/about-us"
              className={`text-base text-semibold ${
                isActive("/about-us") ? "text-main font-bold" : ""
              }`}
            >
              {t("about-us")}
            </Link>
            {/* end about-us */}
            {/* start brands */}
            <Link
              href="/brands"
              className={` text-base text-semibold ${
                isActive("/brands") ? "text-main font-bold" : ""
              }`}
            >
              {t("marks")}
            </Link>
            {/* end brands */}
            {/* start offers */}
            <Link
              href="/offers"
              className={`text-base text-semibold ${
                isActive("/offers") ? "text-main font-bold" : ""
              }`}
            >
              {t("shows")}
            </Link>
            {/* end offers */}
            {/* start blogs*/}
            <Link
              href="/articles"
              className={`text-base text-semibold ${
                isActive("/articles") ? "text-main font-bold" : ""
              }`}
            >
              {t("blogs")}
            </Link>
            {/* end blogs*/}
            {/* start blogs*/}
            <Link
              href="/contact"
              className={`text-base text-semibold ${
                isActive("/contact") ? "text-main font-bold" : ""
              }`}
            >
              {t("contact")}
            </Link>
            {/* end blogs*/}
          </div>

          {/* currency and language switchers */}
          <div className="text-black flex items-center justify-between max-md:hidden gap-2 md:gap-4">
            {settingsResponse?.site_settings?.phone1 && (
              <div className="hidden lg:flex items-center gap-2 me-4">
                <div className="size-10 flex items-center justify-center bg-white rounded-full">
                  <FaPhoneFlip size={20} className="text-main" />
                </div>
                <div>
                  <p className="text-[10px] ">{t("contact")}</p>
                  <p className="text-sm font-semibold">
                    {settingsResponse?.site_settings?.phone1}{" "}
                  </p>
                </div>
              </div>
            )}
            {/* currency */}
            <CurrencySwitcher response={currenciesResponse} />
            {/* langSwitcher */}
            <LangSwitcher
              languages={
                settingsResponse?.languages || siteSettingFallback?.languages
              }
            />
          </div>
        </div>
      </div>
      {/* nav and logo */}
      <div className=" lg:py-4">
        <div className="container flex justify-between items-center gap-6">
          {/* location and language switcher */}
          <div className="text-black flex lg:hidden items-center justify-between max-lg:w-full gap-2 md:gap-4">
            <div className=" flex">
              <Link href="/">
                <FallbackImage
                  src={
                    settingsResponse?.images?.header ||
                    siteSettingFallback?.images?.header
                  }
                  alt="logo"
                  width={50}
                  height={70}
                />
              </Link>
            </div>
            <div className="flex items-center">
              {/* currency */}
              <CurrencySwitcher response={currenciesResponse} />
              {/* langSwitcher */}
              <LangSwitcher
                languages={
                  settingsResponse?.languages || siteSettingFallback?.languages
                }
              />
            </div>
          </div>
          {/* sheet */}
          <div className="block lg:hidden">
            <NavbarSheet profile={profile} />
          </div>
          {/* nav */}
          <div className="text-black hidden lg:flex items-center gap-3">
            {/* start cart */}
            <Cart />
            {/* end cart */}
            {/* start wishlist */}
            <Separator
              orientation="vertical"
              className="h-6 bg-main bg-opacity-30"
            />
            <Link
              href="/wishlist"
              className={`flex items-center gap-2 text-base ${
                isActive("/wishlist") ? "text-main font-bold" : ""
              }`}
            >
              <FaRegHeart size={20} className="text-main" />
              {t("wishlist")}
            </Link>
            {/* end wishlist */}
            {/* start sign in and profile */}
            <Separator
              orientation="vertical"
              className="h-6 bg-main bg-opacity-30"
            />
            {!profile ? (
              <LoginPopover />
            ) : (
              <div className="hidden lg:block">
                <UserDropdown user={profile} />
              </div>
            )}
            {/* end sign in and profile */}
          </div>
          {/* searchbox */}
          <div className="grow hidden lg:block">
            <LightBlueSearchBox />
          </div>
          {/* categories */}
          <div className="hidden lg:block">
            <LightBlueCategoriesMenu response={categoriesResponse} />
          </div>
        </div>
      </div>
    </nav>
  );
}
