import getUserProfile from "@/api/user/getUserProfile";
import UserBreadcrumb from "../ui/User/UserBreadcrumb";
import MobileTap from "../ui/User/UserTab/MobileTap";
import Tap from "../ui/User/UserTab/Tap";

export default async function UserLayout({ children }) {
  const user = await getUserProfile();

  return (
    <section>
      <UserBreadcrumb />
      <div className="mb-5 container">
        <div className="grid grid-cols-12">
          {/* BIG SCREEN TAP */}
          <div className="max-lg:hidden col-span-3 pe-10">
            <div className="h-full">
              <Tap user={user} />
            </div>
          </div>
          {/* SMALL SCREEN TAP */}
          <div className="w-full  lg:hidden col-span-12">
            <MobileTap />
          </div>
          {/* CONTENT */}
          <div className="col-span-12 lg:col-span-9">
            <div className="xl:h-full">
              <div className=" xl:rounded-xl xl:mx-5 my-5  me-auto">
                {children}
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
