import fetchData from "@/api/fetch-data";
import AlertWarning from "@/app/ui/shared/AlertWarning";
import Credit from "@/app/ui/User/credit/credit";
import { getLocale, getTranslations } from "next-intl/server";
export default async function Page() {
  const locale = await getLocale();
  const e = await getTranslations();
  const t = await getTranslations("user");
  const res = await fetchData({ endPoint: "/user/balance", locale });
  const { data, error } = res;

  const nodata = !error && data?.transactions?.length == 0 ? t("nodata") : null;
  if (error) {
    return <AlertWarning text={e("error-message")} />;
  }
  return <Credit data={data} nodata={nodata} />;
}
