import fetchData from "@/api/fetch-data";
import AlertWarning from "@/app/ui/shared/AlertWarning";
import Tickets from "@/app/ui/User/Tickets/Tickets";
import { getLocale } from "next-intl/server";

export default async function Page() {
  const locale = await getLocale();

  // Fetch data
  const ticketsRes = await fetchData({
    endPoint: "/tickets/user/tickets",
    locale,
  }); // tickets fetching
  if (ticketsRes.error) {
    return <AlertWarning text={ticketsRes.message} />;
  }
  const catPirRes = await fetchData({
    endPoint: "/tickets/categories-priorities",
    locale,
  }); //cat-priority

  return (
    <Tickets ticketsData={ticketsRes} catPirData={catPirRes} locale={locale} />
  );
}
