import fetchData from "@/api/fetch-data";
import AlertWarning from "@/app/ui/shared/AlertWarning";
import { toastError } from "@/services/custom-toast";
import { getLocale } from "next-intl/server";
import { FaRegCheckCircle } from "react-icons/fa";

// BY Mohammed Hossam
// Date 22-10-2024
// Notifications page in user layout

export default async function Page() {
  // Get locale and token
  const locale = await getLocale();

  // Fetch data
  const res = await fetchData({ endPoint: "/user/notifications", locale });

  if (res.error) {
    toastError(`There is an error: ${res.message}`);
  }

  const { data, message, error } = res;

  if (error) {
    return <AlertWarning text={message} />;
  }

  return (
    <section>
      <div className="md:w-[80%] me-auto">
        <div className="space-y-3 md:space-y-6">
          {data && Array.isArray(data) && data.length > 0 ? (
            data.map((item, index) => (
              <div
                key={index}
                className="bg-white rounded-2xl p-5 md:py-5 hover:bg-[#E5F7FF] flex flex-col"
              >
                <h5 className="ms-auto">{item.date}</h5>
                <div className="flex items-center gap-x-4 md:gap-x-5">
                  <FaRegCheckCircle className="text-4xl text-green-600" />

                  {/* <FallbackImage src="/alert/checkcircle.png" width={100} height={100} className="size-10 md:size-14" alt="" /> */}
                  <div className="flex flex-col gap-2 md:gap-4">
                    <h4 className="font-semibold">{item.data.name}</h4>
                    <p>{item.data.text}</p>
                  </div>
                </div>
              </div>
            ))
          ) : (
            <AlertWarning
              text={locale === "ar" ? "لا يوجد اشعارات" : "No notifications"}
            />
          )}
        </div>
      </div>
    </section>
  );
}