

import fetchData from "@/api/fetch-data";
import AlertWarning from "@/app/ui/shared/AlertWarning";
import { getLocale, getTranslations } from "next-intl/server";
import { AiOutlineDollar } from "react-icons/ai";
import { FiEye } from "react-icons/fi";
import { GrTransaction } from "react-icons/gr";
import { MdDownloadDone, MdDownloading } from "react-icons/md";
import { PiMoneyWavyLight } from "react-icons/pi";
import { TbShoppingBag } from "react-icons/tb";

export default async function Page() {
  const t = await getTranslations("reports");
  const locale = await getLocale();

  // Initialize variables
  let withdrawalRequestsCount = 0;
  let ordersCount = 0;
  let otherUsersOrdersTotal = 0;
  let affiliatePointsPending = 0;
  let affiliatePointsAvailable = 0;
  let transactionsCount = 0;
  let transactionsTotal = 0;
  let productsVisitsCount = 0;
  let totalEarnings = 0;
  const response = await fetchData({
    endPoint: "/user/reports/all",
    locale
  })

  if (!response.error && response.status == "success") {

    withdrawalRequestsCount = Number(response?.data?.withdrawal_requests_count);
    ordersCount = Number(response?.data?.orders_count);
    otherUsersOrdersTotal = Number(response?.data?.other_users_orders_total).toFixed(2);
    affiliatePointsPending = Number(response?.data?.affiliate_points?.pending);
    affiliatePointsAvailable = Number(response?.data?.affiliate_points?.available);
    transactionsCount = Number(response?.data?.transactions?.transaction_count);
    transactionsTotal = Number(response?.data?.transactions?.total_sum).toFixed(2);
    productsVisitsCount = Number(response?.data?.products_visits_count);
    totalEarnings = Number(response?.data?.total_earnings || 0).toFixed(2);


    return (
      <div className="grid grid-cols-12 gap-6">
        {/* totalEarnings */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("totalEarnings")}</h4>
            <AiOutlineDollar size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{totalEarnings}</p>
        </div>
        {/* transactionsCount */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("transactionsCount")}</h4>
            <GrTransaction size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{transactionsCount}</p>
        </div>
        {/* transactionsTotal */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("transactionsTotal")}</h4>
            <AiOutlineDollar size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{transactionsTotal}</p>
        </div>
        {/* productsVisitsCount */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("productsVisitsCount")}</h4>
            <FiEye size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{productsVisitsCount}</p>
        </div>
        {/* Withdrawal Requests */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("withdrawalRequestsCount")}</h4>
            <PiMoneyWavyLight size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{withdrawalRequestsCount}</p>
        </div>
        {/* ordersCount  */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("ordersCount")}</h4>
            <TbShoppingBag size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{ordersCount}</p>
        </div>
        {/* otherUsersOrdersTotal */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("otherUsersOrdersTotal")}</h4>
            <AiOutlineDollar size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{otherUsersOrdersTotal}</p>
        </div>
        {/* affiliatePointsPending */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("affiliatePointsPending")}</h4>
            <MdDownloading size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{affiliatePointsPending}</p>
        </div>
        {/* affiliatePointsAvailable */}
        <div className="col-span-12 md:col-span-6 lg:col-span-4 bg-white rounded-lg p-6 shadow-md space-y-3">
          <div className="flex items-center justify-between">
            <h4 className="font-bold text-main text-lg">{t("affiliatePointsAvailable")}</h4>
            <MdDownloadDone size={24} className="text-btnColor" />
          </div>
          <p className="text-xl text-btnColor font-bold">{affiliatePointsAvailable}</p>
        </div>


      </div>
    );
  } else {
    return <AlertWarning text={t("error")} />
  }









}
