import { getToken } from "@/actions/cookies";
import fetchData from "@/api/fetch-data";
import CreateWithdrawing from "@/app/ui/User/withdrawing/CreateWithdrawing";
import WithdrawingLimit from "@/app/ui/User/withdrawing/WithdrawingLimit";
import WithdrawingRequests from "@/app/ui/User/withdrawing/WithdrawingRequests";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { getLocale, getTranslations } from "next-intl/server";

export default async function Page() {
  let data;
  const locale = await getLocale();
  const t = await getTranslations("user");
  const token = await getToken();
  const response = await fetchData({ endPoint: "/user/withdraw/limit", token });
  if (response?.status === "success") {
    data = response?.data?.vendor_min_withdrawing_limit || " ";
  }
  return (
    <div>
      <WithdrawingLimit limit={data} />
      <Tabs
        defaultValue="withdrawingrequest"
        className="w-full mt-10"
        dir={locale == "en" ? "ltr" : "rtl"}
      >
        <TabsList className="px-0 pb-5 my-5  bg-transparent border-b-[3px] gap-4 lg:gap-10  border-[#F4F4F4] rounded-none flex duration-100 transition-all w-full justify-start">
          <TabsTrigger
            className=" px-0 lg:text-xl text-[#9DA0A1] data-[state=active]:rounded-none  pb-6 data-[state=active]:border-b-[3px] duration-100 transition-all font-extrabold data-[state=active]:border-main data-[state=active]:bg-transparent data-[state=active]:shadow-none "
            value="withdrawingrequest"
          >
            {t("withdrawingrequest")}
          </TabsTrigger>
          <TabsTrigger
            className=" px-0 lg:text-xl text-[#9DA0A1] data-[state=active]:rounded-none  pb-6 data-[state=active]:border-b-[3px] duration-100 transition-all font-extrabold data-[state=active]:border-main data-[state=active]:bg-transparent data-[state=active]:shadow-none "
            value="createWithdrawing"
          >
            {t("createWithdrawing")}
          </TabsTrigger>
        </TabsList>
        <TabsContent value="withdrawingrequest">
          <WithdrawingRequests />
        </TabsContent>
        <TabsContent value="createWithdrawing">
          <CreateWithdrawing token={token} limit={data} />
        </TabsContent>
      </Tabs>
    </div>
  );
}
