import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import CustomBreadcrumb from "../ui/shared/CustomBreadcrumb";
import AddProductDialog from "../ui/VendorUi/AddProductDialog";
import PaginationVendorProduct from "../ui/VendorUi/PaginationVendorProduct";

export default async function Vendor() {
  const locale = await getLocale();
  const res = await fetchData({
    endPoint: "/user/products/categories",
    locale,
  });
  return (
    <>
      <CustomBreadcrumb />
      <section className="container my-12">
        <AddProductDialog categories={res?.data} />
        <PaginationVendorProduct categories={res?.data} />
      </section>
    </>
  );
}
