import { fetchDataReturnPromise } from "@/actions";
import { useQuery } from "@tanstack/react-query";

export const useFetchData = (
  url,
  lang = "ar",
  isEnabled = false,
  isProtected = false
) => {
  return useQuery({
    queryKey: [url, lang],
    queryFn: () => fetchDataReturnPromise(url, lang, isProtected),
    staleTime: 0,
  });
};
