import { fetchDataInfinite } from "@/actions";
import { useInfiniteQuery } from "@tanstack/react-query";

export const useFetchDataInfinite = (url, lang) => {
  return useInfiniteQuery({
    queryKey: ["data", url, lang], // Include the URL in the query key
    queryFn: ({ pageParam = 1 }) => {
      return fetchDataInfinite(url, pageParam, lang);
    },
    getNextPageParam: (res) => {
      if (res?.currentPage < res?.lastPage) {
        return res?.currentPage + 1;
      }
      return undefined;
    },
    initialPageParam: 1,
    enabled: !!url, // Only fetch if URL is defined
    staleTime: 0,
  });
};
