import { clsx } from "clsx";
import { twMerge } from "tailwind-merge";
import logo from "/public/navbar/logo-fallback.svg";
import userPlaceHolder from "/public/user/profileplaceholder.jpeg";
import notFound from "/public/user/not-found.png";

export function cn(...inputs) {
  return twMerge(clsx(inputs));
}

const validInputTypes = [
  "radio",
  "smalltext",
  "largetext",
  "number",
  "checkbox",
  "image",
  "date",
  "time",
  "datetime",
];

export const convertBackendToFrontendFormInputs = (backendData) => {
  if (!Array.isArray(backendData)) {
    return [];
  }
  return backendData
    ?.filter((item) => validInputTypes.includes(item.type))
    .map((item) => {
      // Base input object
      const input = {
        id: item.code || "",
        fieldName: item.name || "",
        inputType: item.type || "smalltext",
        isRequired: item.required == "1",
        order: parseInt(item.sort || "0"),
        placeHolder: item.desc || "",
      };

      // Handle options for radio and checkbox types
      if (
        (item.type === "radio" || item.type === "checkbox") &&
        item.options &&
        item.options.length > 0
      ) {
        input.options = item.options.map((option) => ({
          id: option.code,
          name: option.name,
          price: option.price,
        }));
      }

      return input;
    })
    .sort((a, b) => a.order - b.order);
};

export const siteSettingFallback = {
  site_settings: {
    id: 1,
    email: "mailto:#",
    logo: logo.src,
    facebook_url: "https://www.facebook.com/",
    tiktok_url: "https://www.tiktok.com/",
    instagram_url: "https://www.instagram.com/",
    twitter_url: "https://x.com/",
    youtube_url: "https://www.youtube.com/",
    snapchat_url: "https://www.snapchat.com/",
    mail_url: "https://mail.google.com/mail/",
    phone1: "",
    phone2: "",
    work_time: "24",
    description: "متجر إلكترونى",
    order_accept: "1",
    product_rating: "1",
    product_outStock: "1",
    discount_codes: "1",
    product_purchases_count: "0",
    similar_products: "1",
    tax_on_product: "1",
    tax_on_shipping: "1",
    maintenance: "0",
    products_per_page_admin: "20",
    products_per_page_website: "10",
    minimum_products_stock_before_sms_notification: "3",
    product_notification_mobile: "",
    product_notification_msg: "تنبيه: متبقي 3 العرض",
    chat_mode: "0",
    chat_code: "",
    points_mode: "1",
    points_minimum: "1",
    points_quantity: "20",
    points_price: "1.00",
    created_at: Date.now(),
    updated_at: Date.now(),
    myfatoorah_type: "live",
    myfatoorah_token: "",
    show_brands: "1",
    show_our_features: "1",
    show_payment_gates: "1",
    show_social_icons: "1",
    captcha_enabled: "0",
    terms_page: null,
    free_shipping: "249",
    is_multi_vendor: "0",
    vendor_min_withdrawing_limit: "5000",
    title: "متجر إلكترونى",
    maintenance_title: "سنعود قريبا ...",
    maintenance_message:
      "عذراً\r\nنحن نعمل على تحسين تجربة  التسوق الخاصة بكم.",
    lang_id: "2",
  },
  user_currency: {
    id: 25,
    currency_id: "10",
    is_default: "1",
    created_at: Date.now(),
    updated_at: Date.now(),
    rate: "1.00",
    name: "الريال السعودي",
    short_name: "ريال",
    flag: "sa",
    code: "SAR",
  },
  languages: [
    {
      id: 2,
      title: "AR",
      code: "ar",
      flag: logo,
      deleted_at: null,
      created_at: Date.now(),
      updated_at: Date.now(),
    },
    {
      id: 1,
      title: "EN",
      code: "en",
      flag: logo,
      deleted_at: null,
      created_at: Date.now(),
      updated_at: Date.now(),
    },
  ],
  store_settings: {
    id: 207,
    subdomain: null,
    domain: "#",
    domain_changed_at: Date.now(),
    domain_status: "#",
    is_active: true,
    owner_id: null,
    package_id: null,
    package_plan_id: null,
    package_plan_price: null,
    package_started_at: null,
    package_ends_at: null,
    sms_package_id: null,
    sms_package_balance: null,
    created_at: Date.now(),
    updated_at: Date.now(),
    package_ends_soon_date: null,
    package_ended_date: null,
  },
  images: {
    id: 1,
    favicon: logo.src,
    header: logo.src,
    footer: logo.src,
    not_found: notFound,
    created_at: Date.now(),
    updated_at: Date.now(),
  },
  image_account: {
    id: 1,
    image_account: userPlaceHolder,
    created_at: Date.now(),
    updated_at: Date.now(),
  },
  image_account_id: 1,
};
