'use server';

import postData from "@/api/post-data";
import { getUserLocale } from "./locale";
import { revalidatePath } from "next/cache";

export async function changeProductVendorImage(formData) {
   const locale = await getUserLocale();
   const res = await postData({
      endPoint: "/user/products/images",
      body: formData,
      locale,
   });
   if (res.error) {
      return res;
   }
   revalidatePath("/vendor");
   return res;
}