"use server";
import postData from "@/api/post-data";
import { revalidatePath } from "next/cache";
import { getUserLocale } from "./locale";

export async function createProductFeature(id, formData) {
  const locale = await getUserLocale();
  const res = await postData({
    endPoint: `/user/products/form/features/${id}`,
    body: formData,
    locale,
  });
  if (res.error) {
    return res;
  }
  revalidatePath(`/vendor/product-vendor-details/${id}`);
  return res;
}
