"use server";
import postData from "@/api/post-data";
import { revalidatePath } from "next/cache";
import { getUserLocale } from "./locale";

export async function deleteProductFeature(id) {
  const locale = await getUserLocale();
  const res = await postData({
    endPoint: `/user/products/features/${id}`,
    locale,
  });
  if (res.error) {
    return res;
  }
  revalidatePath(`/vendor/product-vendor-details/${id}`);
  return res;
}
