'use server';
import { getToken } from "@/actions/cookies";
import { getUserLocale } from "./locale";
import { revalidatePath } from "next/cache";

export async function deleteProduct(id) {
   let code;
   const token = await getToken();
   const locale = await getUserLocale();
   try {
      const response = await fetch(`${process.env.NEXT_PUBLIC_ENDPOINT}/user/products/${id}`, {
         method: "DELETE",
         headers: {
            Authorization: ` Bearer ${token}`,
            "Accept-Language": locale,
            Accept: "application/json",
         }
      });
      code = response.status;
      if (!response.ok) {
         throw new Error('Failed to delete product');
      }
      const data = await response.json();
      revalidatePath('/');
      return { message: data?.data, error: false, code }
   } catch (error) {
      return { message: error.message, error: true, code };
   }
}