"use server";
import fetchData from "@/api/fetch-data";
import { revalidatePath } from "next/cache";
import { getUserLocale } from "./locale";

export async function duplicateProduct(id) {
  const locale = await getUserLocale();
  const res = await fetchData({
    endPoint: `/user/products/duplicate/${id}`,
    locale,
  });
  if (res.error) {
    return res;
  }
  revalidatePath("/vendor");
  return res;
}
