'use server';
import { cookies } from "next/headers";

export async function refreshAccessToken() {
   const refreshToken = cookies().get("refresh_token")?.value;
   const oldToken = cookies().get("token")?.value;

   const formData = new FormData();

   formData.append("refresh_token", refreshToken);
   // Make an API call to refresh the token
   const res = await fetch(`${process.env.NEXT_PUBLIC_ENDPOINT}/user/refresh/token`, {
      method: "POST",
      body: formData,
      headers: {
         Authorization: `Bearer ${oldToken}`,
         Accept: "application/json",
      },
   });
   if (!res.ok) {
      return null;
   }
   const data = await res.json();
   return data?.data;
}