// تعديل الـ Zustand store
import { create } from 'zustand';
import { persist } from 'zustand/middleware';

const useWishlistStore = create(
  persist(
    (set, get) => ({
      wishlist: [],
      
      // Toggle wishlist item
      toggleItem: (item) => {
        const exists = get().wishlist.some((wishlistItem) => wishlistItem
          ?.id === item?.id);
        set({
          wishlist: exists
            ? get().wishlist.filter((wishlistItem) => wishlistItem.id !== item.id)
            : [...get().wishlist, item],
        });
      },

      // تحديث قائمة المفضلة من بيانات الـ API
      setWishlistFromAPI: (apiWishlist) => {
        set({ wishlist: apiWishlist });
      },

      // مسح المفضلة
      clearWishlist: () => set({ wishlist: [] }),
    }),
    {
      name: 'wishlist-storage',
      getStorage: () => localStorage,
    }
  )
);

export default useWishlistStore;
